/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.directdot;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import znaishaded.net.sourceforge.plantuml.AbstractPSystem;
import znaishaded.net.sourceforge.plantuml.CounterOutputStream;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.api.ImageDataSimple;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.ExeState;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.ProcessState;
import znaishaded.net.sourceforge.plantuml.graphic.GraphicStrings;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorUtils;
import znaishaded.net.sourceforge.plantuml.svek.IEntityImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphicUtils;

public class PSystemDot
extends AbstractPSystem {
    private final String data;

    public PSystemDot(String string) {
        this.data = string;
    }

    public DiagramDescription getDescription() {
        return new DiagramDescription("(Dot)");
    }

    protected final ImageData exportDiagramNow(OutputStream outputStream, int n, FileFormatOption fileFormatOption, long l) throws IOException {
        Graphviz graphviz = GraphvizUtils.create(null, this.data, StringUtils.goLowerCase(fileFormatOption.getFileFormat().name()));
        if (graphviz.getExeState() != ExeState.OK) {
            IEntityImage iEntityImage = GraphicStrings.createForError(Arrays.asList("There is an issue with your Dot/Graphviz installation"), false);
            UGraphicUtils.writeImage(outputStream, null, fileFormatOption, this.seed(), new ColorMapperIdentity(), HtmlColorUtils.WHITE, iEntityImage);
            return new ImageDataSimple();
        }
        CounterOutputStream counterOutputStream = new CounterOutputStream(outputStream);
        ProcessState processState = graphviz.createFile3(counterOutputStream);
        if (processState.differs(ProcessState.TERMINATED_OK())) {
            throw new IllegalStateException("Timeout1 " + processState);
        }
        if (counterOutputStream.getLength() == 0) {
            IEntityImage iEntityImage = GraphicStrings.createForError(Arrays.asList("Graphivz has crashed"), false);
            UGraphicUtils.writeImage(outputStream, null, fileFormatOption, this.seed(), new ColorMapperIdentity(), HtmlColorUtils.WHITE, iEntityImage);
        }
        return new ImageDataSimple();
    }
}

