/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.eggs;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.AbstractPSystem;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.SpriteContainerEmpty;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorSetSimple;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorSimple;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorUtils;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import znaishaded.net.sourceforge.plantuml.ugraphic.ImageBuilder;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSystemColors
extends AbstractPSystem
implements UDrawable {
    private final double rectangleHeight = 28.0;
    private final double rectangleWidth = 175.0;
    private final HtmlColorSetSimple colors = new HtmlColorSetSimple();
    private final String paletteCentralColor;
    private final double size = 60.0;

    public PSystemColors(String string) {
        this.paletteCentralColor = string == null ? null : string.replaceAll("\\#", "");
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream outputStream, int n, FileFormatOption fileFormatOption, long l) throws IOException {
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, HtmlColorUtils.WHITE, this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(this);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, l, outputStream);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Colors)");
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        if (this.colors.getColorIfValid(this.paletteCentralColor) instanceof HtmlColorSimple) {
            this.drawPalette(uGraphic);
        } else {
            this.drawFull(uGraphic);
        }
    }

    private void drawPalette(UGraphic uGraphic) {
        double d = (this.centerHexa(2, 0).getX() + this.centerHexa(3, 0).getX()) / 2.0;
        double d2 = this.centerHexa(0, 2).getY() + this.corner(1).getY();
        uGraphic = uGraphic.apply(new UTranslate(d, d2));
        UPolygon uPolygon = this.getHexa();
        List<String> list = this.getColorsCloseTo(this.paletteCentralColor);
        int n = 0;
        this.drawOneHexa(uGraphic, list.get(n++), 0, 0, uPolygon);
        this.drawOneHexa(uGraphic, list.get(n++), 1, 0, uPolygon);
        this.drawOneHexa(uGraphic, list.get(n++), 0, 1, uPolygon);
        this.drawOneHexa(uGraphic, list.get(n++), -1, 1, uPolygon);
        this.drawOneHexa(uGraphic, list.get(n++), -1, 0, uPolygon);
        this.drawOneHexa(uGraphic, list.get(n++), -1, -1, uPolygon);
        this.drawOneHexa(uGraphic, list.get(n++), 0, -1, uPolygon);
        this.drawOneHexa(uGraphic, list.get(n++), 2, 0, uPolygon);
        this.drawOneHexa(uGraphic, list.get(n++), 1, 1, uPolygon);
        this.drawOneHexa(uGraphic, list.get(n++), 1, 2, uPolygon);
        this.drawOneHexa(uGraphic, list.get(n++), 0, 2, uPolygon);
        this.drawOneHexa(uGraphic, list.get(n++), -1, 2, uPolygon);
        this.drawOneHexa(uGraphic, list.get(n++), -2, 1, uPolygon);
        this.drawOneHexa(uGraphic, list.get(n++), -2, 0, uPolygon);
        this.drawOneHexa(uGraphic, list.get(n++), -2, -1, uPolygon);
        this.drawOneHexa(uGraphic, list.get(n++), -1, -2, uPolygon);
        this.drawOneHexa(uGraphic, list.get(n++), 0, -2, uPolygon);
        this.drawOneHexa(uGraphic, list.get(n++), 1, -2, uPolygon);
        this.drawOneHexa(uGraphic, list.get(n++), 1, -1, uPolygon);
    }

    private Point2D centerHexa(int n, int n2) {
        double d = this.getWidth();
        double d2 = d * (double)n + (n2 % 2 == 0 ? 0.0 : d / 2.0);
        double d3 = 60.0 * (double)n2 * 1.5;
        return new Point2D.Double(d2, d3);
    }

    private double getWidth() {
        return Math.sqrt(3.0) / 2.0 * 2.0 * 60.0;
    }

    private void drawOneHexa(UGraphic uGraphic, String string, int n, int n2, UPolygon uPolygon) {
        HtmlColorSimple htmlColorSimple = (HtmlColorSimple)this.colors.getColorIfValid(string);
        uGraphic = this.applyColor(uGraphic, htmlColorSimple);
        uGraphic = uGraphic.apply(new UTranslate(this.centerHexa(n, n2)));
        uGraphic.draw(uPolygon);
        UFont uFont = UFont.sansSerif(14).bold();
        TextBlock textBlock = this.getTextName(uFont, string, htmlColorSimple);
        Dimension2D dimension2D = textBlock.calculateDimension(uGraphic.getStringBounder());
        if (dimension2D.getWidth() > this.getWidth()) {
            textBlock = this.getTextName(uFont, this.findShortest(uGraphic.getStringBounder(), uFont, string), htmlColorSimple);
            dimension2D = textBlock.calculateDimension(uGraphic.getStringBounder());
        }
        textBlock.drawU(uGraphic.apply(new UTranslate(-dimension2D.getWidth() / 2.0, -dimension2D.getHeight() / 2.0)));
    }

    private String findShortest(StringBounder stringBounder, UFont uFont, String string) {
        String string2 = null;
        double d = Double.MAX_VALUE;
        for (int i = 1; i < string.length() - 1; ++i) {
            String string3;
            TextBlock textBlock;
            double d2;
            if (Character.isLowerCase(string.charAt(i)) || !((d2 = (textBlock = this.getTextName(uFont, string3 = string.substring(0, i) + "\\n" + string.substring(i), (HtmlColorSimple)HtmlColorUtils.BLACK)).calculateDimension(stringBounder).getWidth()) < d)) continue;
            string2 = string3;
            d = d2;
        }
        return string2;
    }

    private UGraphic applyColor(UGraphic uGraphic, HtmlColor htmlColor) {
        return uGraphic.apply(new UChangeColor(htmlColor)).apply(new UChangeBackColor(htmlColor));
    }

    private Point2D corner(int n) {
        double d = 60 * n + 30;
        double d2 = Math.PI / 180 * d;
        return new Point2D.Double(60.0 * Math.cos(d2), 60.0 * Math.sin(d2));
    }

    private UPolygon getHexa() {
        UPolygon uPolygon = new UPolygon();
        for (int i = 0; i < 6; ++i) {
            uPolygon.addPoint(this.corner(i));
        }
        return uPolygon;
    }

    private List<String> getColorsCloseTo(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(this.colors.names());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string2;
            String string3 = (String)iterator.next();
            if (string3.equals(string2 = string3.replaceAll("Gray", "Grey")) || !arrayList.contains(string2)) continue;
            iterator.remove();
        }
        if (!this.containsCaseInsensitive(arrayList, string)) {
            arrayList.add(string);
        }
        Collections.sort(arrayList, this.closeComparator(this.paletteCentralColor));
        return arrayList;
    }

    private boolean containsCaseInsensitive(Collection<String> collection, String string) {
        for (String string2 : collection) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private Comparator<String> closeComparator(String string) {
        final HtmlColorSimple htmlColorSimple = (HtmlColorSimple)this.colors.getColorIfValid(string);
        return new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                double d = htmlColorSimple.distance((HtmlColorSimple)PSystemColors.this.colors.getColorIfValid(string));
                double d2 = htmlColorSimple.distance((HtmlColorSimple)PSystemColors.this.colors.getColorIfValid(string2));
                return (int)Math.signum(d - d2);
            }
        };
    }

    private void drawFull(UGraphic uGraphic) {
        UFont uFont = UFont.sansSerif(14).bold();
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK));
        int n = 0;
        int n2 = 0;
        for (String string : this.colors.names()) {
            UGraphic uGraphic2 = this.getPositioned(uGraphic, n, n2);
            HtmlColorSimple htmlColorSimple = (HtmlColorSimple)this.colors.getColorIfValid(string);
            this.applyColor(uGraphic2, htmlColorSimple).draw(new URectangle(175.0, 28.0));
            TextBlock textBlock = this.getTextName(uFont, string, htmlColorSimple);
            Dimension2D dimension2D = textBlock.calculateDimension(uGraphic.getStringBounder());
            double d = (28.0 - dimension2D.getHeight()) / 2.0;
            double d2 = (175.0 - dimension2D.getWidth()) / 2.0;
            textBlock.drawU(uGraphic2.apply(new UTranslate(d2, d)));
            if (n2++ != 20) continue;
            n2 = 0;
            ++n;
        }
    }

    private TextBlock getTextName(UFont uFont, String string, HtmlColorSimple htmlColorSimple) {
        HtmlColorSimple htmlColorSimple2 = htmlColorSimple.opposite();
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, htmlColorSimple2, HtmlColorUtils.BLUE, true);
        TextBlock textBlock = Display.getWithNewlines(string).create(fontConfiguration, HorizontalAlignment.CENTER, new SpriteContainerEmpty());
        return textBlock;
    }

    private UGraphic getPositioned(UGraphic uGraphic, int n, int n2) {
        return uGraphic.apply(new UTranslate(175.0 * (double)n, 28.0 * (double)n2));
    }
}

