/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom.kinetic;

import java.awt.geom.Point2D;

public class VectorForce {
    private final double x;
    private final double y;

    public VectorForce(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isInfinite(d) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException();
        }
        this.x = d;
        this.y = d2;
    }

    public VectorForce(Point2D point2D, Point2D point2D2) {
        this(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
    }

    public VectorForce plus(VectorForce vectorForce) {
        return new VectorForce(this.x + vectorForce.x, this.y + vectorForce.y);
    }

    public VectorForce multiply(double d) {
        return new VectorForce(this.x * d, this.y * d);
    }

    public String toString() {
        return String.format("{%8.2f %8.2f}", this.x, this.y);
    }

    public VectorForce negate() {
        return new VectorForce(-this.x, -this.y);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public VectorForce normaliseTo(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException();
        }
        double d2 = this.length();
        if (d2 == 0.0) {
            return this;
        }
        double d3 = d / d2;
        return new VectorForce(this.x * d3, this.y * d3);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }
}

