/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graph2;

import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import znaishaded.net.sourceforge.plantuml.graph2.GeomUtils;
import znaishaded.net.sourceforge.plantuml.graph2.IInflationTransform;
import znaishaded.net.sourceforge.plantuml.graph2.InflateData2;
import znaishaded.net.sourceforge.plantuml.graph2.Point2DComparatorDistance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InflationTransform2
implements IInflationTransform {
    private final List<InflateData2> inflateX = new ArrayList<InflateData2>();
    private final List<InflateData2> inflateY = new ArrayList<InflateData2>();

    @Override
    public void addInflationX(double d, double d2) {
        InflationTransform2.add(this.inflateX, d, d2);
    }

    public String toString() {
        return "inflateX = " + this.inflateX + " inflateY = " + this.inflateY;
    }

    @Override
    public void addInflationY(double d, double d2) {
        InflationTransform2.add(this.inflateY, d, d2);
    }

    @Override
    public double getTotalInflationX() {
        return InflationTransform2.sumInflation(this.inflateX);
    }

    @Override
    public double getTotalInflationY() {
        return InflationTransform2.sumInflation(this.inflateY);
    }

    private static double sumInflation(List<InflateData2> list) {
        double d = 0.0;
        for (InflateData2 inflateData2 : list) {
            d += inflateData2.getInflation();
        }
        return d;
    }

    private static void add(List<InflateData2> list, double d, double d2) {
        ListIterator<InflateData2> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            InflateData2 inflateData2 = listIterator.next();
            if (inflateData2.getPos() != d) continue;
            listIterator.set(new InflateData2(d, Math.max(d2, inflateData2.getInflation())));
            return;
        }
        list.add(new InflateData2(d, d2));
        Collections.sort(list);
    }

    Collection<Point2D.Double> cutPoints(Line2D.Double double_) {
        Point2D.Double double_2;
        Line2D.Double double_3;
        TreeSet<Point2D> treeSet = new TreeSet<Point2D>(new Point2DComparatorDistance(double_.getP1()));
        if (!GeomUtils.isHorizontal(double_)) {
            for (InflateData2 inflateData2 : this.inflateX) {
                double_3 = new Line2D.Double(inflateData2.getPos(), GeomUtils.getMinY(double_), inflateData2.getPos(), GeomUtils.getMaxY(double_));
                double_2 = GeomUtils.getSegIntersection(double_, double_3);
                if (double_2 == null) continue;
                treeSet.add(double_2);
            }
        }
        if (!GeomUtils.isVertical(double_)) {
            for (InflateData2 inflateData2 : this.inflateY) {
                double_3 = new Line2D.Double(GeomUtils.getMinX(double_), inflateData2.getPos(), GeomUtils.getMaxX(double_), inflateData2.getPos());
                double_2 = GeomUtils.getSegIntersection(double_, double_3);
                if (double_2 == null) continue;
                treeSet.add(double_2);
            }
        }
        return treeSet;
    }

    Collection<Line2D.Double> cutSegments(Line2D.Double double_) {
        ArrayList<Line2D.Double> arrayList = new ArrayList<Line2D.Double>();
        Point2D.Double double_2 = (Point2D.Double)double_.getP1();
        Collection<Point2D.Double> collection = this.cutPoints(double_);
        for (Point2D.Double double_3 : collection) {
            if (double_2.equals(double_3)) continue;
            arrayList.add(new Line2D.Double(double_2, double_3));
            double_2 = double_3;
        }
        if (!double_2.equals(double_.getP2())) {
            arrayList.add(new Line2D.Double(double_2, double_.getP2()));
        }
        return arrayList;
    }

    Collection<Line2D.Double> cutSegments(Collection<Line2D.Double> collection) {
        ArrayList<Line2D.Double> arrayList = new ArrayList<Line2D.Double>();
        for (Line2D.Double double_ : collection) {
            arrayList.addAll(this.cutSegments(double_));
        }
        return arrayList;
    }

    @Override
    public Point2D inflatePoint2D(Point2D point2D) {
        return this.getAffineTransformAt(point2D).transform(point2D, null);
    }

    AffineTransform getAffineTransformAt(Point2D point2D) {
        double d = 0.0;
        for (InflateData2 inflateData2 : this.inflateX) {
            d += inflateData2.inflateAt(point2D.getX());
        }
        double d2 = 0.0;
        for (InflateData2 inflateData2 : this.inflateY) {
            d2 += inflateData2.inflateAt(point2D.getY());
        }
        return AffineTransform.getTranslateInstance(d, d2);
    }

    List<Line2D.Double> inflateSegmentCollection(Collection<Line2D.Double> collection) {
        ArrayList<Line2D.Double> arrayList = new ArrayList<Line2D.Double>();
        for (Line2D.Double double_ : collection) {
            AffineTransform affineTransform = this.getAffineTransformAt(new Point2D.Double((double_.x1 + double_.x2) / 2.0, (double_.y1 + double_.y2) / 2.0));
            arrayList.add(new Line2D.Double(affineTransform.transform(double_.getP1(), null), affineTransform.transform(double_.getP2(), null)));
        }
        return arrayList;
    }

    @Override
    public List<Line2D.Double> inflate(Collection<Line2D.Double> collection) {
        Collection<Line2D.Double> collection2 = this.cutSegments(collection);
        Line2D.Double double_ = null;
        List<Line2D.Double> list = this.inflateSegmentCollection(collection2);
        ArrayList<Line2D.Double> arrayList = new ArrayList<Line2D.Double>();
        for (Line2D.Double double_2 : list) {
            if (double_ != null && !double_.getP2().equals(double_2.getP1())) {
                arrayList.add(new Line2D.Double(double_.getP2(), double_2.getP1()));
            }
            arrayList.add(double_2);
            double_ = double_2;
        }
        return arrayList;
    }
}

