/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graph2;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.geom.Orientation;
import znaishaded.net.sourceforge.plantuml.graph2.Singularity2;

public class Neighborhood2 {
    private final double angle1;
    private final double angle2;
    private final Point2D.Double center;

    public Neighborhood2(Point2D.Double double_) {
        this(double_, 0.0, 0.0);
    }

    public boolean is360() {
        return this.angle1 == this.angle2;
    }

    public Neighborhood2(Point2D.Double double_, double d, double d2) {
        this.center = double_;
        this.angle1 = d;
        this.angle2 = d2;
    }

    public boolean equals(Object object) {
        Neighborhood2 neighborhood2 = (Neighborhood2)object;
        return this.angle1 == neighborhood2.angle1 && this.angle2 == neighborhood2.angle2 && this.center.equals(neighborhood2.center);
    }

    public int hashCode() {
        return this.center.hashCode() * 17 + new Point2D.Double(this.angle1, this.angle2).hashCode();
    }

    public String toString() {
        int n = (int)(this.angle1 * 180.0 / Math.PI);
        int n2 = (int)(this.angle2 * 180.0 / Math.PI);
        return this.center + " " + n + " " + n2;
    }

    public final Point2D.Double getCenter() {
        return this.center;
    }

    public Point2D.Double getPointInNeighborhood(double d, Point2D point2D, Point2D point2D2) {
        if (point2D == null || point2D2 == null) {
            throw new IllegalArgumentException();
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        double d2 = Singularity2.convertAngle(Singularity2.getAngle(new Line2D.Double(this.center, point2D)) - this.angle1);
        double d3 = Singularity2.convertAngle(Singularity2.getAngle(new Line2D.Double(this.center, point2D2)) - this.angle1);
        if (d2 < 0.0) {
            throw new IllegalStateException();
        }
        if (d3 < 0.0) {
            throw new IllegalStateException();
        }
        double d4 = (d2 + d3) / 2.0 + this.angle1;
        return new Point2D.Double(this.center.x + d * Math.cos(d4), this.center.y + d * Math.sin(d4));
    }

    public boolean isInAngleStrict(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.angle2 > this.angle1) {
            return d > this.angle1 && d < this.angle2;
        }
        return d > this.angle1 || d < this.angle2;
    }

    public boolean isInAngleLarge(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.angle2 > this.angle1) {
            return d >= this.angle1 && d <= this.angle2;
        }
        return d >= this.angle1 || d <= this.angle2;
    }

    public boolean isAngleLimit(double d) {
        return d == this.angle1 || d == this.angle2;
    }

    public Orientation getOrientationFrom(double d) {
        if (this.angle1 == this.angle2) {
            throw new IllegalStateException();
        }
        if (d != this.angle1 && d != this.angle2) {
            throw new IllegalArgumentException("this=" + this + " angle=" + (int)(d * 180.0 / Math.PI));
        }
        assert (d == this.angle1 || d == this.angle2);
        if (d == this.angle1) {
            return Orientation.MATH;
        }
        return Orientation.CLOCK;
    }

    public boolean isConnectable(Neighborhood2 neighborhood2) {
        assert (this.isConnectableInternal(neighborhood2) == neighborhood2.isConnectableInternal(this));
        return this.isConnectableInternal(neighborhood2);
    }

    private boolean isConnectableInternal(Neighborhood2 neighborhood2) {
        if (this.getCenter().equals(neighborhood2.getCenter())) {
            throw new IllegalArgumentException("Same center");
        }
        Line2D.Double double_ = new Line2D.Double(this.getCenter(), neighborhood2.getCenter());
        double d = Singularity2.convertAngle(Singularity2.getAngle(double_));
        double d2 = Singularity2.convertAngle(Singularity2.getOppositeAngle(double_));
        assert (d2 == Singularity2.convertAngle(Singularity2.getAngle(new Line2D.Double(neighborhood2.getCenter(), this.getCenter()))));
        if (this.isInAngleStrict(d) && neighborhood2.isInAngleStrict(d2)) {
            return true;
        }
        if (this.isInAngleStrict(d) && neighborhood2.isInAngleLarge(d2)) {
            return true;
        }
        if (this.isInAngleLarge(d) && neighborhood2.isInAngleStrict(d2)) {
            return true;
        }
        if (this.isAngleLimit(d) && neighborhood2.isAngleLimit(d2)) {
            Orientation orientation;
            if (this.is360() || neighborhood2.is360()) {
                return true;
            }
            Orientation orientation2 = this.getOrientationFrom(d);
            return orientation2 != (orientation = neighborhood2.getOrientationFrom(d2));
        }
        return false;
    }
}

