/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkStyle;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.IHtmlColorSet;
import znaishaded.net.sourceforge.plantuml.graphic.Rainbow;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;

public class HtmlColorAndStyle {
    private static final Rose rose = new Rose();
    private final HtmlColor color;
    private final LinkStyle style;

    public String toString() {
        return this.color + " " + (Object)((Object)this.style);
    }

    public static Rainbow fromColor(HtmlColor htmlColor) {
        if (htmlColor == null) {
            return Rainbow.none();
        }
        return Rainbow.build(new HtmlColorAndStyle(htmlColor));
    }

    public static Rainbow build(ISkinParam iSkinParam) {
        return HtmlColorAndStyle.fromColor(rose.getHtmlColor(iSkinParam, ColorParam.arrow));
    }

    private HtmlColorAndStyle(HtmlColor htmlColor) {
        this(htmlColor, LinkStyle.NORMAL);
    }

    public HtmlColorAndStyle(HtmlColor htmlColor, LinkStyle linkStyle) {
        if (htmlColor == null) {
            throw new IllegalArgumentException();
        }
        this.color = htmlColor;
        this.style = linkStyle;
    }

    public HtmlColor getColor() {
        return this.color;
    }

    public LinkStyle getStyle() {
        return this.style;
    }

    public static HtmlColorAndStyle build(ISkinParam iSkinParam, String string) {
        HtmlColor htmlColor = HtmlColorAndStyle.build((ISkinParam)iSkinParam).getColors().get((int)0).color;
        LinkStyle linkStyle = LinkStyle.NORMAL;
        IHtmlColorSet iHtmlColorSet = iSkinParam.getIHtmlColorSet();
        for (String string2 : string.split(",")) {
            LinkStyle linkStyle2 = LinkStyle.fromString(string2);
            if (linkStyle2 != LinkStyle.NORMAL) {
                linkStyle = linkStyle2;
                continue;
            }
            HtmlColor htmlColor2 = iHtmlColorSet.getColorIfValid(string2);
            if (htmlColor2 == null) continue;
            htmlColor = htmlColor2;
        }
        return new HtmlColorAndStyle(htmlColor, linkStyle);
    }
}

