/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.StringTokenizer;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UText;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class TileText
extends AbstractTextBlock
implements TextBlock {
    private final String text;
    private final FontConfiguration fontConfiguration;
    private final Url url;

    public TileText(String string, FontConfiguration fontConfiguration, Url url) {
        this.fontConfiguration = fontConfiguration;
        this.text = string;
        this.url = url;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = stringBounder.calculateDimension(this.fontConfiguration.getFont(), this.text);
        int n = Math.abs(this.fontConfiguration.getSpace());
        Log.debug("g2d=" + dimension2D);
        Log.debug("Size for " + this.text + " is " + dimension2D);
        double d = dimension2D.getHeight();
        if (d < 10.0) {
            d = 10.0;
        }
        double d2 = this.text.indexOf(9) == -1 ? dimension2D.getWidth() : this.getWidth(stringBounder);
        return new Dimension2DDouble(d2, d + (double)n);
    }

    public double getFontSize2D() {
        return this.fontConfiguration.getFont().getSize2D();
    }

    double getTabSize(StringBounder stringBounder) {
        return stringBounder.calculateDimension(this.fontConfiguration.getFont(), "        ").getWidth();
    }

    public void drawU(UGraphic uGraphic) {
        double d = 0.0;
        if (this.url != null) {
            uGraphic.startUrl(this.url);
        }
        uGraphic = uGraphic.apply(new UChangeColor(this.fontConfiguration.getColor()));
        StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\t", true);
        if (stringTokenizer.hasMoreTokens()) {
            double d2 = this.getTabSize(uGraphic.getStringBounder());
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (string.equals("\t")) {
                    double d3 = d % d2;
                    d += d2 - d3;
                    continue;
                }
                UText uText = new UText(string, this.fontConfiguration);
                Dimension2D dimension2D = uGraphic.getStringBounder().calculateDimension(this.fontConfiguration.getFont(), string);
                int n = this.fontConfiguration.getSpace();
                double d4 = n < 0 ? (double)n : (double)n;
                uGraphic.apply(new UTranslate(d, d4)).draw(uText);
                d += dimension2D.getWidth();
            }
        }
        if (this.url != null) {
            uGraphic.closeAction();
        }
    }

    double getWidth(StringBounder stringBounder) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\t", true);
        double d = this.getTabSize(stringBounder);
        double d2 = 0.0;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equals("\t")) {
                double d3 = d2 % d;
                d2 += d - d3;
                continue;
            }
            Dimension2D dimension2D = stringBounder.calculateDimension(this.fontConfiguration.getFont(), string);
            d2 += dimension2D.getWidth();
        }
        return d2;
    }
}

