/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.hector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.hector.Pin;
import znaishaded.net.sourceforge.plantuml.hector.PinLink;
import znaishaded.net.sourceforge.plantuml.hector.Skeleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrowingTree {
    private final List<PinLink> all = new ArrayList<PinLink>();
    private final Map<Pin, ArrayList<Pin>> directlyAfter = new HashMap<Pin, ArrayList<Pin>>();

    public Skeleton createSkeleton() {
        LinkedHashSet<Pin> linkedHashSet = new LinkedHashSet<Pin>();
        for (PinLink pinLink : this.all) {
            linkedHashSet.add(pinLink.getPin1());
            linkedHashSet.add(pinLink.getPin2());
        }
        this.normalizeRowToZero(linkedHashSet);
        return new Skeleton(new ArrayList<Pin>(linkedHashSet), new ArrayList<PinLink>(this.all));
    }

    private void normalizeRowToZero(Collection<Pin> collection) {
        int n = Integer.MAX_VALUE;
        for (Pin pin : collection) {
            int n2 = pin.getRow();
            if (n2 == Integer.MAX_VALUE) {
                throw new IllegalStateException();
            }
            if (n2 >= n) continue;
            n = n2;
        }
        for (Pin pin : collection) {
            pin.push(-n);
        }
    }

    public boolean canBeAdded(PinLink pinLink) {
        if (this.all.size() == 0) {
            return true;
        }
        Pin pin = pinLink.getPin1();
        Pin pin2 = pinLink.getPin2();
        return pin.getRow() != Integer.MAX_VALUE || pin2.getRow() != Integer.MAX_VALUE;
    }

    public void add(PinLink pinLink) {
        Pin pin = pinLink.getPin1();
        Pin pin2 = pinLink.getPin2();
        if (this.all.size() == 0) {
            pinLink.getPin1().setRow(0);
            this.simpleRowComputation(pinLink);
        } else if (this.isPartiallyNew(pinLink)) {
            this.simpleRowComputation(pinLink);
        } else if (pin.getRow() != Integer.MAX_VALUE && pin2.getRow() != Integer.MAX_VALUE) {
            int n = pin2.getRow() - pin.getRow();
            int n2 = pinLink.getLengthStandard() - n;
            this.push(pin2, n2);
        } else {
            throw new IllegalArgumentException();
        }
        this.all.add(pinLink);
        this.getDirectlyAfter(pin).add(pin2);
    }

    private List<Pin> getDirectlyAfter(Pin pin) {
        ArrayList<Pin> arrayList = this.directlyAfter.get(pin);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.directlyAfter.put(pin, arrayList);
        }
        return arrayList;
    }

    private Collection<Pin> getIndirectlyAfter(Pin pin) {
        HashSet<Pin> hashSet = new HashSet<Pin>(this.getDirectlyAfter(pin));
        int n = hashSet.size();
        while (true) {
            for (Pin pin2 : new ArrayList<Pin>(hashSet)) {
                hashSet.addAll(this.getDirectlyAfter(pin2));
            }
            if (hashSet.size() == n) {
                return hashSet;
            }
            n = hashSet.size();
        }
    }

    private void push(Pin pin, int n) {
        if (n <= 0) {
            return;
        }
        Collection<Pin> collection = this.getIndirectlyAfter(pin);
        if (collection.contains(pin)) {
            throw new IllegalStateException();
        }
        pin.push(n);
        for (Pin pin2 : collection) {
            pin2.push(n);
        }
    }

    private void simpleRowComputation(PinLink pinLink) {
        Pin pin = pinLink.getPin1();
        Pin pin2 = pinLink.getPin2();
        if (pin.getRow() == Integer.MAX_VALUE && pin2.getRow() != Integer.MAX_VALUE) {
            pin.setRow(pin2.getRow() - pinLink.getLengthStandard());
        } else if (pin.getRow() != Integer.MAX_VALUE && pin2.getRow() == Integer.MAX_VALUE) {
            pin2.setRow(pin.getRow() + pinLink.getLengthStandard());
        } else {
            throw new IllegalArgumentException();
        }
    }

    private boolean isPartiallyNew(PinLink pinLink) {
        Pin pin = pinLink.getPin1();
        Pin pin2 = pinLink.getPin2();
        if (pin.getRow() == Integer.MAX_VALUE && pin2.getRow() != Integer.MAX_VALUE) {
            return true;
        }
        return pin.getRow() != Integer.MAX_VALUE && pin2.getRow() == Integer.MAX_VALUE;
    }

    public void normalizeRowToZero() {
    }
}

