/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.png;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import znaishaded.net.sourceforge.plantuml.Log;

public class PngSizer {
    public static BufferedImage process(BufferedImage bufferedImage, int n) {
        if (n != Integer.MAX_VALUE) {
            return PngSizer.resize(bufferedImage, n);
        }
        return bufferedImage;
    }

    private static BufferedImage resize(BufferedImage bufferedImage, int n) {
        Log.info("Resizing file to " + n);
        if (bufferedImage.getWidth() >= n) {
            return bufferedImage;
        }
        BufferedImage bufferedImage2 = new BufferedImage(n, bufferedImage.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        int n2 = (n - bufferedImage.getWidth()) / 2;
        graphics2D.drawImage((Image)bufferedImage, n2, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }
}

