/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.salt.DataSource;
import znaishaded.net.sourceforge.plantuml.salt.Terminated;
import znaishaded.net.sourceforge.plantuml.salt.Terminator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceImpl
implements DataSource {
    private int i = 0;
    private final List<Terminated<String>> data = new ArrayList<Terminated<String>>();

    public DataSourceImpl(List<String> list) {
        Pattern2 pattern2 = MyPattern.cmpile("\\{[-+^#!*/]?");
        for (String string : list) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|}", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = StringUtils.trin(stringTokenizer.nextToken());
                if (string2.equals("|")) continue;
                Terminator terminator = stringTokenizer.hasMoreTokens() ? Terminator.NEWCOL : Terminator.NEWLINE;
                Matcher2 matcher2 = pattern2.matcher(string2);
                boolean bl = matcher2.find();
                if (!bl) {
                    this.addInternal(string2, terminator);
                    continue;
                }
                int n = 0;
                int n2 = 0;
                do {
                    int n3;
                    if ((n3 = matcher2.start()) > n) {
                        this.addInternal(string2.substring(n, n3), Terminator.NEWCOL);
                    }
                    Terminator terminator2 = (n2 = matcher2.end()) == string2.length() ? terminator : Terminator.NEWCOL;
                    this.addInternal(string2.substring(n3, n2), terminator2);
                    n = n2;
                } while (matcher2.find());
                if (n2 >= string2.length()) continue;
                this.addInternal(string2.substring(n2), terminator);
            }
        }
    }

    private void addInternal(String string, Terminator terminator) {
        if ((string = StringUtils.trin(string)).length() > 0) {
            this.data.add(new Terminated<String>(string, terminator));
        }
    }

    @Override
    public Terminated<String> peek(int n) {
        return this.data.get(this.i + n);
    }

    @Override
    public boolean hasNext() {
        return this.i < this.data.size();
    }

    @Override
    public Terminated<String> next() {
        Terminated<String> terminated = this.data.get(this.i);
        ++this.i;
        return terminated;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return super.toString() + " " + (this.hasNext() ? this.peek(0) : "$$$");
    }
}

