/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram;

import java.util.Set;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParamBackcolored;
import znaishaded.net.sourceforge.plantuml.SpecificBackcolorable;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.EntityPortion;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.sequencediagram.ParticipantType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Participant
implements SpecificBackcolorable {
    private final String code;
    private Display display;
    private final ParticipantType type;
    private int initialLife = 0;
    private Stereotype stereotype;
    private boolean stereotypePositionTop;
    private final Set<EntityPortion> hiddenPortions;
    private SymbolContext liveBackcolors;
    private Colors colors = Colors.empty();
    private Url url;

    public Participant(ParticipantType participantType, String string, Display display, Set<EntityPortion> set) {
        this.hiddenPortions = set;
        if (participantType == null) {
            throw new IllegalArgumentException();
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (Display.isNull(display) || display.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.code = string;
        this.type = participantType;
        this.display = display;
    }

    public String getCode() {
        return this.code;
    }

    public String toString() {
        return this.getCode();
    }

    public Display getDisplay(boolean bl) {
        Display display;
        Display display2 = display = bl ? this.display.underlined() : this.display;
        if (this.stereotype != null && !this.hiddenPortions.contains((Object)EntityPortion.STEREOTYPE)) {
            display = this.stereotypePositionTop ? display.addFirst(this.stereotype) : display.add(this.stereotype);
        }
        return display;
    }

    public ParticipantType getType() {
        return this.type;
    }

    public final void setStereotype(Stereotype stereotype, boolean bl) {
        if (this.stereotype != null) {
            throw new IllegalStateException();
        }
        if (stereotype == null) {
            throw new IllegalArgumentException();
        }
        this.stereotype = stereotype;
        this.stereotypePositionTop = bl;
    }

    public final int getInitialLife() {
        return this.initialLife;
    }

    public final void incInitialLife(SymbolContext symbolContext) {
        ++this.initialLife;
        this.liveBackcolors = symbolContext;
    }

    public SymbolContext getLiveSpecificBackColors() {
        return this.liveBackcolors;
    }

    @Override
    public Colors getColors(ISkinParam iSkinParam) {
        return this.colors;
    }

    public void setSpecificColorTOBEREMOVED(ColorType colorType, HtmlColor htmlColor) {
        if (htmlColor != null) {
            this.colors = this.colors.add(colorType, htmlColor);
        }
    }

    @Override
    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public final Url getUrl() {
        return this.url;
    }

    public final void setUrl(Url url) {
        this.url = url;
    }

    public final Stereotype getStereotype() {
        return this.stereotype;
    }

    public ColorParam getBackgroundColorParam() {
        return this.type.getBackgroundColorParam();
    }

    public SkinParamBackcolored getSkinParamBackcolored(ISkinParam iSkinParam) {
        HtmlColor htmlColor = this.getColors(iSkinParam).getColor(ColorType.BACK);
        boolean bl = this.getUrl() != null;
        HtmlColor htmlColor2 = iSkinParam.getHtmlColor(this.getBackgroundColorParam(), this.getStereotype(), bl);
        if (htmlColor2 != null && htmlColor == null) {
            htmlColor = htmlColor2;
        }
        SkinParamBackcolored skinParamBackcolored = new SkinParamBackcolored(iSkinParam, htmlColor, bl);
        HtmlColor htmlColor3 = iSkinParam.getHtmlColor(ColorParam.participantBorder, this.getStereotype(), bl);
        if (htmlColor3 != null) {
            skinParamBackcolored.forceColor(ColorParam.participantBorder, htmlColor3);
        }
        return skinParamBackcolored;
    }
}

