/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.real.RealUtils;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Note;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteStyle;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.skin.Skin;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class NoteTile
implements Tile {
    private final LivingSpace livingSpace1;
    private final LivingSpace livingSpace2;
    private final Skin skin;
    private final ISkinParam skinParam;
    private final Note note;

    public Event getEvent() {
        return this.note;
    }

    public NoteTile(LivingSpace livingSpace, LivingSpace livingSpace2, Note note, Skin skin, ISkinParam iSkinParam) {
        this.livingSpace1 = livingSpace;
        this.livingSpace2 = livingSpace2;
        this.note = note;
        this.skin = skin;
        this.skinParam = iSkinParam;
    }

    private Component getComponent(StringBounder stringBounder) {
        Component component = this.skin.createComponent(this.getNoteComponentType(this.note.getStyle()), null, this.note.getSkinParamBackcolored(this.skinParam), this.note.getStrings());
        return component;
    }

    private ComponentType getNoteComponentType(NoteStyle noteStyle) {
        if (noteStyle == NoteStyle.HEXAGONAL) {
            return ComponentType.NOTE_HEXAGONAL;
        }
        if (noteStyle == NoteStyle.BOX) {
            return ComponentType.NOTE_BOX;
        }
        return ComponentType.NOTE;
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        double d = this.getX(stringBounder).getCurrentValue();
        Area area = new Area(this.getUsedWidth(stringBounder), dimension2D.getHeight());
        uGraphic = uGraphic.apply(new UTranslate(d, 0.0));
        component.drawU(uGraphic, area, (Context2D)((Object)uGraphic));
    }

    private double getUsedWidth(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        double d = dimension2D.getWidth();
        if (this.note.getPosition() == NotePosition.OVER_SEVERAL) {
            double d2 = this.livingSpace1.getPosB().getCurrentValue();
            double d3 = this.livingSpace2.getPosD(stringBounder).getCurrentValue();
            double d4 = d3 - d2;
            if (d < d4) {
                return d4;
            }
        }
        return d;
    }

    private Real getX(StringBounder stringBounder) {
        NotePosition notePosition = this.note.getPosition();
        double d = this.getUsedWidth(stringBounder);
        if (notePosition == NotePosition.LEFT) {
            return this.livingSpace1.getPosC(stringBounder).addFixed(-d);
        }
        if (notePosition == NotePosition.RIGHT) {
            int n = this.livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            double d2 = (double)n * 5.0;
            return this.livingSpace1.getPosC(stringBounder).addFixed(d2);
        }
        if (notePosition == NotePosition.OVER_SEVERAL) {
            Real real = this.livingSpace1.getPosC(stringBounder);
            Real real2 = this.livingSpace2.getPosC(stringBounder);
            return RealUtils.middle(real, real2).addFixed(-d / 2.0);
        }
        if (notePosition == NotePosition.OVER) {
            return this.livingSpace1.getPosC(stringBounder).addFixed(-d / 2.0);
        }
        throw new UnsupportedOperationException(notePosition.toString());
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        return dimension2D.getHeight();
    }

    public void addConstraints(StringBounder stringBounder) {
    }

    public Real getMinX(StringBounder stringBounder) {
        Real real = this.getX(stringBounder);
        if (this.note.getPosition() == NotePosition.OVER_SEVERAL) {
            Real real2 = this.livingSpace1.getPosB();
            return RealUtils.min(real, real2);
        }
        return real;
    }

    public Real getMaxX(StringBounder stringBounder) {
        Real real = this.getX(stringBounder).addFixed(this.getUsedWidth(stringBounder));
        if (this.note.getPosition() == NotePosition.OVER_SEVERAL) {
            Real real2 = this.livingSpace2.getPosD(stringBounder);
            return RealUtils.max(real, real2);
        }
        return real;
    }
}

