/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.skin;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum VisibilityModifier {
    PRIVATE_FIELD(ColorParam.iconPrivate, null),
    PROTECTED_FIELD(ColorParam.iconProtected, null),
    PACKAGE_PRIVATE_FIELD(ColorParam.iconPackage, null),
    PUBLIC_FIELD(ColorParam.iconPublic, null),
    PRIVATE_METHOD(ColorParam.iconPrivate, ColorParam.iconPrivateBackground),
    PROTECTED_METHOD(ColorParam.iconProtected, ColorParam.iconProtectedBackground),
    PACKAGE_PRIVATE_METHOD(ColorParam.iconPackage, ColorParam.iconPackageBackground),
    PUBLIC_METHOD(ColorParam.iconPublic, ColorParam.iconPublicBackground),
    IE_MANDATORY(ColorParam.iconIEMandatory, ColorParam.iconIEMandatory);

    private final ColorParam foregroundParam;
    private final ColorParam backgroundParam;

    public static String regexForVisibilityCharacterInClassName() {
        return "[-#+~]";
    }

    private VisibilityModifier(ColorParam colorParam, ColorParam colorParam2) {
        this.foregroundParam = colorParam;
        this.backgroundParam = colorParam2;
    }

    public UDrawable getUDrawable(final int n, final HtmlColor htmlColor, final HtmlColor htmlColor2) {
        return new UDrawable(){

            public void drawU(UGraphic uGraphic) {
                VisibilityModifier.this.drawInternal(uGraphic, n, htmlColor, htmlColor2, 0.0, 0.0);
            }
        };
    }

    public TextBlock getUBlock(final int n, final HtmlColor htmlColor, final HtmlColor htmlColor2, final boolean bl) {
        return new AbstractTextBlock(){

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(n + 1, n + 1);
            }

            public Rectangle2D getInnerPosition(String string, StringBounder stringBounder, InnerStrategy innerStrategy) {
                return null;
            }

            public void drawU(UGraphic uGraphic) {
                if (bl) {
                    uGraphic.apply(new UChangeColor(null)).draw(new URectangle(n * 2, n));
                }
                VisibilityModifier.this.drawInternal(uGraphic, n, htmlColor, htmlColor2, 0.0, 0.0);
            }
        };
    }

    private void drawInternal(UGraphic uGraphic, int n, HtmlColor htmlColor, HtmlColor htmlColor2, double d, double d2) {
        uGraphic = uGraphic.apply(new UChangeBackColor(htmlColor2)).apply(new UChangeColor(htmlColor));
        n = VisibilityModifier.ensureEven(n);
        switch (this) {
            case PACKAGE_PRIVATE_FIELD: {
                this.drawTriangle(uGraphic, false, n, d, d2);
                break;
            }
            case PRIVATE_FIELD: {
                this.drawSquare(uGraphic, false, n, d, d2);
                break;
            }
            case PROTECTED_FIELD: {
                this.drawDiamond(uGraphic, false, n, d, d2);
                break;
            }
            case PUBLIC_FIELD: {
                this.drawCircle(uGraphic, false, n, d, d2);
                break;
            }
            case PACKAGE_PRIVATE_METHOD: {
                this.drawTriangle(uGraphic, true, n, d, d2);
                break;
            }
            case PRIVATE_METHOD: {
                this.drawSquare(uGraphic, true, n, d, d2);
                break;
            }
            case PROTECTED_METHOD: {
                this.drawDiamond(uGraphic, true, n, d, d2);
                break;
            }
            case PUBLIC_METHOD: {
                this.drawCircle(uGraphic, true, n, d, d2);
                break;
            }
            case IE_MANDATORY: {
                this.drawCircle(uGraphic, true, n, d, d2);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void drawSquare(UGraphic uGraphic, boolean bl, int n, double d, double d2) {
        uGraphic.apply(new UTranslate(d + 2.0, d2 + 2.0)).draw(new URectangle(n - 4, n - 4));
    }

    private void drawCircle(UGraphic uGraphic, boolean bl, int n, double d, double d2) {
        uGraphic.apply(new UTranslate(d + 2.0, d2 + 2.0)).draw(new UEllipse(n - 4, n - 4));
    }

    private static int ensureEven(int n) {
        if (n % 2 == 1) {
            --n;
        }
        return n;
    }

    private void drawDiamond(UGraphic uGraphic, boolean bl, int n, double d, double d2) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint((double)(n -= 2) / 2.0, 0.0);
        uPolygon.addPoint(n, (double)n / 2.0);
        uPolygon.addPoint((double)n / 2.0, n);
        uPolygon.addPoint(0.0, (double)n / 2.0);
        uGraphic.apply(new UTranslate(d + 1.0, d2)).draw(uPolygon);
    }

    private void drawTriangle(UGraphic uGraphic, boolean bl, int n, double d, double d2) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint((double)(n -= 2) / 2.0, 1.0);
        uPolygon.addPoint(0.0, n - 1);
        uPolygon.addPoint(n, n - 1);
        uGraphic.apply(new UTranslate(d + 1.0, d2)).draw(uPolygon);
    }

    public static boolean isVisibilityCharacter(CharSequence charSequence) {
        if (charSequence.length() <= 2) {
            return false;
        }
        char c = charSequence.charAt(0);
        if (charSequence.charAt(1) == c) {
            return false;
        }
        if (c == '-') {
            return true;
        }
        if (c == '#') {
            return true;
        }
        if (c == '+') {
            return true;
        }
        if (c == '~') {
            return true;
        }
        return c == '*';
    }

    public static VisibilityModifier getVisibilityModifier(CharSequence charSequence, boolean bl) {
        if (charSequence.length() <= 2) {
            return null;
        }
        char c = charSequence.charAt(0);
        if (charSequence.charAt(1) == c) {
            return null;
        }
        if (bl) {
            return VisibilityModifier.getVisibilityModifierForField(c);
        }
        return VisibilityModifier.getVisibilityModifierForMethod(c);
    }

    private static VisibilityModifier getVisibilityModifierForField(char c) {
        if (c == '-') {
            return PRIVATE_FIELD;
        }
        if (c == '#') {
            return PROTECTED_FIELD;
        }
        if (c == '+') {
            return PUBLIC_FIELD;
        }
        if (c == '~') {
            return PACKAGE_PRIVATE_FIELD;
        }
        if (c == '*') {
            return IE_MANDATORY;
        }
        return null;
    }

    private static VisibilityModifier getVisibilityModifierForMethod(char c) {
        if (c == '-') {
            return PRIVATE_METHOD;
        }
        if (c == '#') {
            return PROTECTED_METHOD;
        }
        if (c == '+') {
            return PUBLIC_METHOD;
        }
        if (c == '~') {
            return PACKAGE_PRIVATE_METHOD;
        }
        if (c == '*') {
            return IE_MANDATORY;
        }
        return null;
    }

    public final ColorParam getForeground() {
        return this.foregroundParam;
    }

    public final ColorParam getBackground() {
        return this.backgroundParam;
    }

    public String getXmiVisibility() {
        if (this == PUBLIC_FIELD || this == PUBLIC_METHOD) {
            return "public";
        }
        if (this == PRIVATE_FIELD || this == PRIVATE_METHOD) {
            return "private";
        }
        if (this == PROTECTED_FIELD || this == PROTECTED_METHOD) {
            return "protected";
        }
        if (this == PACKAGE_PRIVATE_FIELD || this == PACKAGE_PRIVATE_METHOD) {
            return "package";
        }
        throw new IllegalStateException();
    }
}

