/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.skin.rose;

import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.skin.AbstractTextualComponent;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseParticipant
extends AbstractTextualComponent {
    private final HtmlColor back;
    private final HtmlColor foregroundColor;
    private final double deltaShadow;
    private final double roundCorner;
    private final UStroke stroke;
    private final double minWidth;
    private final boolean collections;
    private final double padding;

    public ComponentRoseParticipant(SymbolContext symbolContext, FontConfiguration fontConfiguration, Display display, ISkinSimple iSkinSimple, double d, UFont uFont, HtmlColor htmlColor, double d2, boolean bl, double d3) {
        super(LineBreakStrategy.NONE, display, fontConfiguration, HorizontalAlignment.CENTER, 7, 7, 7, iSkinSimple, false, uFont, htmlColor);
        this.padding = d3;
        this.minWidth = d2;
        this.collections = bl;
        this.back = symbolContext.getBackColor();
        this.roundCorner = d;
        this.deltaShadow = symbolContext.getDeltaShadow();
        this.foregroundColor = symbolContext.getForeColor();
        this.stroke = symbolContext.getStroke();
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic = uGraphic.apply(new UTranslate(this.padding, 0.0));
        uGraphic = uGraphic.apply(new UChangeBackColor(this.back)).apply(new UChangeColor(this.foregroundColor));
        uGraphic = uGraphic.apply(this.stroke);
        URectangle uRectangle = new URectangle(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder), this.roundCorner, this.roundCorner);
        uRectangle.setDeltaShadow(this.deltaShadow);
        if (this.collections) {
            uGraphic.apply(new UTranslate(this.getDeltaCollection(), 0.0)).draw(uRectangle);
            uGraphic = uGraphic.apply(new UTranslate(0.0, this.getDeltaCollection()));
        }
        uGraphic.draw(uRectangle);
        uGraphic = uGraphic.apply(new UStroke());
        TextBlock textBlock = this.getTextBlock();
        textBlock.drawU(uGraphic.apply(new UTranslate((double)this.getMarginX1() + this.suppWidth(stringBounder) / 2.0, this.getMarginY())));
    }

    private double getDeltaCollection() {
        if (this.collections) {
            return 4.0;
        }
        return 0.0;
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + this.deltaShadow + 1.0 + this.getDeltaCollection();
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + this.deltaShadow + this.getDeltaCollection() + 2.0 * this.padding;
    }

    protected double getPureTextWidth(StringBounder stringBounder) {
        return Math.max(super.getPureTextWidth(stringBounder), this.minWidth);
    }

    private final double suppWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) - super.getPureTextWidth(stringBounder);
    }
}

