/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.stats;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.stats.HumanDuration;
import znaishaded.net.sourceforge.plantuml.stats.api.Stats;
import znaishaded.net.sourceforge.plantuml.stats.api.StatsColumn;
import znaishaded.net.sourceforge.plantuml.stats.api.StatsLine;
import znaishaded.net.sourceforge.plantuml.stats.api.StatsTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreoleConverter {
    private final DateFormat formatter = DateFormat.getDateTimeInstance(3, 2);
    private final Stats stats;

    public CreoleConverter(Stats stats) {
        this.stats = stats;
    }

    public List<String> toCreole() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("<b><size:16>Statistics</b>");
        this.printTableCreole(arrayList, this.stats.getLastSessions());
        arrayList.add(" ");
        arrayList.add("<b><size:16>Current session statistics</b>");
        this.printTableCreole(arrayList, this.stats.getCurrentSessionByDiagramType());
        arrayList.add(" ");
        this.printTableCreole(arrayList, this.stats.getCurrentSessionByFormat());
        arrayList.add(" ");
        arrayList.add("<b><size:16>General statistics since ever</b>");
        this.printTableCreole(arrayList, this.stats.getAllByDiagramType());
        arrayList.add(" ");
        this.printTableCreole(arrayList, this.stats.getAllByFormat());
        return arrayList;
    }

    private void printTableCreole(List<String> list, StatsTable statsTable) {
        Collection<StatsColumn> collection = statsTable.getColumnHeaders();
        list.add(this.getCreoleHeader(collection));
        List<StatsLine> list2 = statsTable.getLines();
        for (int i = 0; i < list2.size(); ++i) {
            StatsLine statsLine = list2.get(i);
            boolean bl = i == list2.size() - 1;
            list.add(this.getCreoleLine(collection, statsLine, bl));
        }
    }

    private String getCreoleLine(Collection<StatsColumn> collection, StatsLine statsLine, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (StatsColumn statsColumn : collection) {
            Object object = statsLine.getValue(statsColumn);
            stringBuilder.append("|");
            if (object instanceof Long || object instanceof HumanDuration) {
                stringBuilder.append("<r> ");
            } else {
                stringBuilder.append(" ");
            }
            if (bl) {
                stringBuilder.append("<b>");
            }
            if (object instanceof Long) {
                stringBuilder.append(String.format("%,d", object));
            } else if (object instanceof Date) {
                stringBuilder.append(this.formatter.format(object));
            } else if (object == null || object.toString().length() == 0) {
                stringBuilder.append(" ");
            } else {
                stringBuilder.append(object.toString());
            }
            if (bl) {
                stringBuilder.append("</b>");
            }
            stringBuilder.append(" ");
        }
        stringBuilder.append("|");
        return stringBuilder.toString();
    }

    private String getCreoleHeader(Collection<StatsColumn> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (StatsColumn statsColumn : collection) {
            stringBuilder.append("| ");
            stringBuilder.append(statsColumn.getTitle());
            stringBuilder.append(" ");
        }
        stringBuilder.append("|");
        return stringBuilder.toString();
    }
}

