/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.LineParam;
import znaishaded.net.sourceforge.plantuml.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.cucadiagram.EntityPosition;
import znaishaded.net.sourceforge.plantuml.cucadiagram.EntityUtils;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IGroup;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Member;
import znaishaded.net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorTransparent;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockEmpty;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockWidth;
import znaishaded.net.sourceforge.plantuml.graphic.USymbol;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.posimo.Moveable;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.svek.ClusterDecoration;
import znaishaded.net.sourceforge.plantuml.svek.ClusterPosition;
import znaishaded.net.sourceforge.plantuml.svek.ColorSequence;
import znaishaded.net.sourceforge.plantuml.svek.DotMode;
import znaishaded.net.sourceforge.plantuml.svek.FrontierCalculator;
import znaishaded.net.sourceforge.plantuml.svek.IShapePseudo;
import znaishaded.net.sourceforge.plantuml.svek.Line;
import znaishaded.net.sourceforge.plantuml.svek.PackageStyle;
import znaishaded.net.sourceforge.plantuml.svek.RoundedContainer;
import znaishaded.net.sourceforge.plantuml.svek.Shape;
import znaishaded.net.sourceforge.plantuml.svek.ShapePseudoImpl;
import znaishaded.net.sourceforge.plantuml.svek.SvekUtils;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageState;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UComment;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.utils.UniqueSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cluster
implements Moveable {
    private final Cluster parent;
    private final IGroup group;
    private final List<Shape> shapes = new ArrayList<Shape>();
    private final List<Cluster> children = new ArrayList<Cluster>();
    private final int color;
    private final int colorTitle;
    private final ISkinParam skinParam;
    private int titleAndAttributeWidth;
    private int titleAndAttributeHeight;
    private TextBlock ztitle;
    private TextBlock zstereo;
    private double xTitle;
    private double yTitle;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private ColorParam border;
    public static final String CENTER_ID = "za";

    @Override
    public void moveSvek(double d, double d2) {
        this.xTitle += d;
        this.minX += d;
        this.maxX += d;
        this.yTitle += d2;
        this.minY += d2;
        this.maxY += d2;
    }

    private boolean hasEntryOrExitPoint() {
        for (Shape shape : this.shapes) {
            if (shape.getEntityPosition() == EntityPosition.NORMAL) continue;
            return true;
        }
        return false;
    }

    public Cluster(ColorSequence colorSequence, ISkinParam iSkinParam, IGroup iGroup) {
        this(null, iGroup, colorSequence, iSkinParam);
    }

    private Cluster(Cluster cluster, IGroup iGroup, ColorSequence colorSequence, ISkinParam iSkinParam) {
        if (iGroup == null) {
            throw new IllegalStateException();
        }
        this.parent = cluster;
        this.group = iGroup;
        if (iGroup.getUSymbol() != null) {
            this.border = iGroup.getUSymbol().getColorParamBorder();
        }
        this.color = colorSequence.getValue();
        this.colorTitle = colorSequence.getValue();
        this.skinParam = iGroup.getColors(iSkinParam).mute(iSkinParam);
    }

    public String toString() {
        return super.toString() + " " + this.group;
    }

    public final Cluster getParent() {
        return this.parent;
    }

    public void addShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        this.shapes.add(shape);
        shape.setCluster(this);
    }

    public final List<Shape> getShapes() {
        return Collections.unmodifiableList(this.shapes);
    }

    private List<Shape> getShapesOrderedTop(Collection<Line> collection) {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, Shape> hashMap = new HashMap<String, Shape>();
        for (Shape moveable : this.shapes) {
            hashMap.put(moveable.getUid(), moveable);
            if (!moveable.isTop() || moveable.getEntityPosition() != EntityPosition.NORMAL) continue;
            arrayList.add(moveable);
            hashSet.add(moveable.getUid());
        }
        for (Line line : collection) {
            Shape shape;
            if (hashSet.contains(line.getStartUidPrefix()) && (shape = (Shape)hashMap.get(line.getEndUidPrefix())) != null && shape.getEntityPosition() == EntityPosition.NORMAL) {
                arrayList.add(0, shape);
            }
            if (!line.isInverted() || (shape = (Shape)hashMap.get(line.getStartUidPrefix())) == null || shape.getEntityPosition() != EntityPosition.NORMAL) continue;
            arrayList.add(0, shape);
        }
        return arrayList;
    }

    private List<Shape> getShapesEntryExit(EnumSet<EntityPosition> enumSet) {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        for (Shape shape : this.shapes) {
            if (!enumSet.contains((Object)shape.getEntityPosition())) continue;
            arrayList.add(shape);
        }
        return arrayList;
    }

    private List<Shape> getShapesOrderedWithoutTop(Collection<Line> collection) {
        ArrayList<Shape> arrayList = new ArrayList<Shape>(this.shapes);
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, Shape> hashMap = new HashMap<String, Shape>();
        Iterator<Object> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Shape moveable = (Shape)iterator.next();
            if (moveable.getEntityPosition() != EntityPosition.NORMAL) {
                iterator.remove();
                continue;
            }
            hashMap.put(moveable.getUid(), moveable);
            if (!moveable.isTop()) continue;
            hashSet.add(moveable.getUid());
            iterator.remove();
        }
        for (Line line : collection) {
            Shape shape;
            if (hashSet.contains(line.getStartUidPrefix()) && (shape = (Shape)hashMap.get(line.getEndUidPrefix())) != null) {
                arrayList.remove(shape);
            }
            if (!line.isInverted() || (shape = (Shape)hashMap.get(line.getStartUidPrefix())) == null) continue;
            arrayList.remove(shape);
        }
        return arrayList;
    }

    public final List<Cluster> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Cluster createChild(IGroup iGroup, int n, int n2, TextBlock textBlock, TextBlock textBlock2, ColorSequence colorSequence, ISkinParam iSkinParam) {
        Cluster cluster = new Cluster(this, iGroup, colorSequence, iSkinParam);
        cluster.titleAndAttributeWidth = n;
        cluster.titleAndAttributeHeight = n2;
        cluster.ztitle = textBlock;
        cluster.zstereo = textBlock2;
        this.children.add(cluster);
        return cluster;
    }

    public final IGroup getGroup() {
        return this.group;
    }

    public final int getTitleAndAttributeWidth() {
        return this.titleAndAttributeWidth;
    }

    public final int getTitleAndAttributeHeight() {
        return this.titleAndAttributeHeight;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getMinX() {
        return this.minX;
    }

    public ClusterPosition getClusterPosition() {
        return new ClusterPosition(this.minX, this.minY, this.maxX, this.maxY);
    }

    public void setTitlePosition(double d, double d2) {
        this.xTitle = d;
        this.yTitle = d2;
    }

    private static HtmlColor getColor(ColorParam colorParam, ISkinParam iSkinParam, Stereotype stereotype) {
        return SkinParamUtils.getColor(iSkinParam, colorParam, stereotype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawU(UGraphic uGraphic, UStroke uStroke, UmlDiagramType umlDiagramType, ISkinParam iSkinParam) {
        uGraphic.draw(new UComment("cluster " + this.group.getCode().getFullName()));
        Stereotype stereotype = this.group.getStereotype();
        HtmlColor htmlColor = umlDiagramType == UmlDiagramType.STATE ? Cluster.getColor(ColorParam.stateBorder, this.skinParam, stereotype) : (umlDiagramType == UmlDiagramType.ACTIVITY ? Cluster.getColor(ColorParam.packageBorder, this.skinParam, stereotype) : Cluster.getColor(ColorParam.packageBorder, this.skinParam, stereotype));
        Url url = this.group.getUrl99();
        if (url != null) {
            uGraphic.startUrl(url);
        }
        try {
            Object object;
            boolean bl;
            if (this.hasEntryOrExitPoint()) {
                this.manageEntryExitPoint(uGraphic.getStringBounder());
            }
            if (this.skinParam.useSwimlanes(umlDiagramType)) {
                this.drawSwinLinesState(uGraphic, htmlColor);
                return;
            }
            boolean bl2 = bl = umlDiagramType == UmlDiagramType.STATE;
            if (bl) {
                if (this.group.getColors(this.skinParam).getSpecificLineStroke() != null) {
                    uStroke = this.group.getColors(this.skinParam).getSpecificLineStroke();
                }
                if (this.group.getColors(this.skinParam).getColor(ColorType.LINE) != null) {
                    htmlColor = this.group.getColors(this.skinParam).getColor(ColorType.LINE);
                }
                this.drawUState(uGraphic, htmlColor, iSkinParam, uStroke, umlDiagramType);
                return;
            }
            PackageStyle packageStyle = this.group.getPackageStyle();
            if (packageStyle == null) {
                packageStyle = iSkinParam.getPackageStyle();
            }
            if (this.border != null && (object = iSkinParam.getHtmlColor(this.border, this.group.getStereotype(), false)) != null) {
                htmlColor = object;
            }
            if (this.ztitle != null || this.zstereo != null) {
                object = Cluster.getBackColor(this.getBackColor(umlDiagramType), iSkinParam, this.group.getStereotype());
                double d = this.group.getUSymbol() == null ? 0.0 : this.group.getUSymbol().getSkinParameter().getRoundCorner(this.skinParam, stereotype);
                ClusterDecoration clusterDecoration = new ClusterDecoration(packageStyle, this.group.getUSymbol(), this.ztitle, this.zstereo, this.minX, this.minY, this.maxX, this.maxY, this.getStroke(iSkinParam, this.group.getStereotype()));
                clusterDecoration.drawU(uGraphic, (HtmlColor)object, htmlColor, iSkinParam.shadowing(), d);
                return;
            }
            object = new URectangle(this.maxX - this.minX, this.maxY - this.minY);
            if (iSkinParam.shadowing()) {
                ((URectangle)object).setDeltaShadow(3.0);
            }
            HtmlColor htmlColor2 = Cluster.getBackColor(this.getBackColor(umlDiagramType), iSkinParam, this.group.getStereotype());
            uGraphic = uGraphic.apply(new UChangeBackColor(htmlColor2)).apply(new UChangeColor(htmlColor));
            uGraphic.apply(new UStroke(2.0)).apply(new UTranslate(this.minX, this.minY)).draw((UShape)object);
        }
        finally {
            if (url != null) {
                uGraphic.closeAction();
            }
        }
    }

    private UStroke getStroke(ISkinParam iSkinParam, Stereotype stereotype) {
        UStroke uStroke = iSkinParam.getThickness(LineParam.packageBorder, stereotype);
        if (uStroke == null) {
            uStroke = new UStroke(2.0);
        }
        return uStroke;
    }

    public void manageEntryExitPoint(StringBounder stringBounder) {
        ArrayList<ClusterPosition> arrayList = new ArrayList<ClusterPosition>();
        ArrayList<Point2D> arrayList2 = new ArrayList<Point2D>();
        for (Shape object2 : this.shapes) {
            if (object2.getEntityPosition() == EntityPosition.NORMAL) {
                arrayList.add(object2.getClusterPosition());
                continue;
            }
            arrayList2.add(object2.getClusterPosition().getPointCenter());
        }
        for (Cluster cluster : this.children) {
            arrayList.add(cluster.getClusterPosition());
        }
        FrontierCalculator frontierCalculator = new FrontierCalculator(this.getClusterPosition(), arrayList, arrayList2);
        if (this.titleAndAttributeHeight > 0 && this.titleAndAttributeWidth > 0) {
            frontierCalculator.ensureMinWidth(this.titleAndAttributeWidth + 10);
        }
        ClusterPosition clusterPosition = frontierCalculator.getSuggestedPosition();
        this.xTitle += (clusterPosition.getMinX() - this.minX + (clusterPosition.getMaxX() - this.maxX)) / 2.0;
        this.minX = clusterPosition.getMinX();
        this.minY = clusterPosition.getMinY();
        this.maxX = clusterPosition.getMaxX();
        this.maxY = clusterPosition.getMaxY();
        this.yTitle = this.minY + 5.0;
        double d = this.ztitle.calculateDimension(stringBounder).getWidth();
        this.xTitle = this.minX + (this.maxX - this.minX - d) / 2.0;
    }

    private void drawSwinLinesState(UGraphic uGraphic, HtmlColor htmlColor) {
        if (this.ztitle != null) {
            this.ztitle.drawU(uGraphic.apply(new UTranslate(this.xTitle, 0.0)));
        }
        ULine uLine = new ULine(0.0, this.maxY - this.minY);
        uGraphic = uGraphic.apply(new UChangeColor(htmlColor));
        uGraphic.apply(new UTranslate(this.minX, 0.0)).draw(uLine);
        uGraphic.apply(new UTranslate(this.maxX, 0.0)).draw(uLine);
    }

    private HtmlColor getColor(ISkinParam iSkinParam, ColorParam colorParam, Stereotype stereotype) {
        return new Rose().getHtmlColor(iSkinParam, colorParam, stereotype);
    }

    private void drawUState(UGraphic uGraphic, HtmlColor htmlColor, ISkinParam iSkinParam, UStroke uStroke, UmlDiagramType umlDiagramType) {
        Stereotype stereotype;
        boolean bl;
        double d;
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(this.maxX - this.minX, this.maxY - this.minY);
        double d2 = this.ztitle == null ? 0.0 : this.ztitle.calculateDimension(uGraphic.getStringBounder()).getHeight() + 5.0 + 5.0;
        HtmlColor htmlColor2 = this.getBackColor(umlDiagramType);
        if (htmlColor2 == null) {
            htmlColor2 = this.getColor(iSkinParam, ColorParam.stateBackground, this.group.getStereotype());
        }
        HtmlColor htmlColor3 = this.getColor(iSkinParam, ColorParam.background, null);
        TextBlockWidth textBlockWidth = this.getTextBlockAttribute(iSkinParam);
        RoundedContainer roundedContainer = new RoundedContainer(dimension2DDouble, d2, d + (double)((d = textBlockWidth.calculateDimension(uGraphic.getStringBounder()).getHeight()) > 0.0 ? 5 : 0), htmlColor, htmlColor2, htmlColor3, uStroke);
        roundedContainer.drawU(uGraphic.apply(new UTranslate(this.minX, this.minY)), iSkinParam.shadowing());
        if (this.ztitle != null) {
            this.ztitle.drawU(uGraphic.apply(new UTranslate(this.xTitle, this.yTitle)));
        }
        if (d > 0.0) {
            textBlockWidth.asTextBlock(((Dimension2D)dimension2DDouble).getWidth()).drawU(uGraphic.apply(new UTranslate(this.minX + 5.0, this.minY + d2 + 2.5)));
        }
        boolean bl2 = bl = (stereotype = this.group.getStereotype()) != null && stereotype.isWithOOSymbol();
        if (bl) {
            EntityImageState.drawSymbol(uGraphic.apply(new UChangeColor(htmlColor)), this.maxX, this.maxY);
        }
    }

    private TextBlockWidth getTextBlockAttribute(ISkinParam iSkinParam) {
        List<Member> list = this.group.getBodier().getFieldsToDisplay();
        AbstractTextBlock abstractTextBlock = list.size() == 0 ? new TextBlockEmpty() : new MethodsOrFieldsArea(list, FontParam.STATE_ATTRIBUTE, iSkinParam, this.group.getStereotype(), null);
        return abstractTextBlock;
    }

    public void setPosition(double d, double d2, double d3, double d4) {
        this.minX = d;
        this.maxX = d3;
        this.minY = d2;
        this.maxY = d4;
    }

    private boolean isThereALinkFromOrToGroup(Collection<Line> collection) {
        for (Line line : collection) {
            if (!line.isLinkFromOrTo(this.group)) continue;
            return true;
        }
        return false;
    }

    public void printCluster1(StringBuilder stringBuilder, Collection<Line> collection, StringBounder stringBounder) {
        for (Shape shape : this.getShapesOrderedTop(collection)) {
            shape.appendShape(stringBuilder, stringBounder);
        }
    }

    private List<IShapePseudo> addProtection(List<Shape> list, double d) {
        ArrayList<IShapePseudo> arrayList = new ArrayList<IShapePseudo>();
        arrayList.add(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            arrayList.add(new ShapePseudoImpl("psd" + UniqueSequence.getValue(), d, 5.0));
            arrayList.add(list.get(i));
        }
        return arrayList;
    }

    private double getMaxWidthFromLabelForEntryExit(List<Shape> list, StringBounder stringBounder) {
        double d = -1.7976931348623157E308;
        for (Shape shape : list) {
            double d2 = this.getMaxWidthFromLabelForEntryExit(shape, stringBounder);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    private double getMaxWidthFromLabelForEntryExit(Shape shape, StringBounder stringBounder) {
        return shape.getMaxWidthFromLabelForEntryExit(stringBounder);
    }

    public void printClusterEntryExit(StringBuilder stringBuilder, StringBounder stringBounder) {
        Iterator<IShapePseudo> iterator;
        List<Shape> list = this.getShapesEntryExit(EntityPosition.getInputs());
        double d = this.getMaxWidthFromLabelForEntryExit(list, stringBounder);
        List<IShapePseudo> list2 = d > 70.0 ? this.addProtection(list, d - 70.0) : list;
        if (list2.size() > 0) {
            stringBuilder.append("{rank=source;");
            for (IShapePseudo iterator22 : list2) {
                stringBuilder.append(iterator22.getUid() + ";");
            }
            stringBuilder.append("}");
            iterator = list2.iterator();
            while (iterator.hasNext()) {
                IShapePseudo iShapePseudo = iterator.next();
                iShapePseudo.appendShape(stringBuilder, stringBounder);
            }
        }
        if ((iterator = this.getShapesEntryExit(EntityPosition.getOutputs())).size() > 0) {
            Shape shape;
            stringBuilder.append("{rank=sink;");
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                shape = (Shape)iterator2.next();
                stringBuilder.append(shape.getUid() + ";");
            }
            stringBuilder.append("}");
            Iterator iterator3 = iterator.iterator();
            while (iterator3.hasNext()) {
                shape = (Shape)iterator3.next();
                shape.appendShape(stringBuilder, stringBounder);
            }
        }
    }

    public boolean printCluster2(StringBuilder stringBuilder, Collection<Line> collection, StringBounder stringBounder, DotMode dotMode, GraphvizVersion graphvizVersion, UmlDiagramType umlDiagramType) {
        boolean bl = false;
        for (Shape moveable : this.getShapesOrderedWithoutTop(collection)) {
            moveable.appendShape(stringBuilder, stringBounder);
            bl = true;
        }
        if (this.skinParam.useRankSame() && dotMode != DotMode.NO_LEFT_RIGHT_AND_XLABEL) {
            this.appendRankSame(stringBuilder, collection);
        }
        for (Cluster cluster : this.getChildren()) {
            cluster.printInternal(stringBuilder, collection, stringBounder, dotMode, graphvizVersion, umlDiagramType);
        }
        return bl;
    }

    private void appendRankSame(StringBuilder stringBuilder, Collection<Line> collection) {
        for (String string : this.getRankSame(collection)) {
            stringBuilder.append(string);
            SvekUtils.println(stringBuilder);
        }
    }

    private Set<String> getRankSame(Collection<Line> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Line line : collection) {
            String string;
            if (line.hasEntryPoint()) continue;
            String string2 = line.getStartUidPrefix();
            String string3 = line.getEndUidPrefix();
            if (!this.isInCluster(string2) || !this.isInCluster(string3) || (string = line.rankSame()) == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public void fillRankMin(Set<String> set) {
        for (Shape moveable : this.getShapes()) {
            if (!moveable.isTop()) continue;
            set.add(moveable.getUid());
        }
        for (Cluster cluster : this.getChildren()) {
            cluster.fillRankMin(set);
        }
    }

    private boolean isInCluster(String string) {
        for (Shape shape : this.shapes) {
            if (!shape.getUid().equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getClusterId() {
        return "cluster" + this.color;
    }

    public static String getSpecialPointId(IEntity iEntity) {
        return CENTER_ID + iEntity.getUid();
    }

    private boolean protection0(UmlDiagramType umlDiagramType) {
        return !this.skinParam.useSwimlanes(umlDiagramType);
    }

    private boolean protection1(UmlDiagramType umlDiagramType) {
        if (this.group.getUSymbol() == USymbol.NODE) {
            return true;
        }
        return !this.skinParam.useSwimlanes(umlDiagramType);
    }

    public String getMinPoint(UmlDiagramType umlDiagramType) {
        if (this.skinParam.useSwimlanes(umlDiagramType)) {
            return "minPoint" + this.color;
        }
        return null;
    }

    public String getMaxPoint(UmlDiagramType umlDiagramType) {
        if (this.skinParam.useSwimlanes(umlDiagramType)) {
            return "maxPoint" + this.color;
        }
        return null;
    }

    private String getSourceInPoint(UmlDiagramType umlDiagramType) {
        if (this.skinParam.useSwimlanes(umlDiagramType)) {
            return "sourceIn" + this.color;
        }
        return null;
    }

    private String getSinkInPoint(UmlDiagramType umlDiagramType) {
        if (this.skinParam.useSwimlanes(umlDiagramType)) {
            return "sinkIn" + this.color;
        }
        return null;
    }

    private void printInternal(StringBuilder stringBuilder, Collection<Line> collection, StringBounder stringBounder, DotMode dotMode, GraphvizVersion graphvizVersion, UmlDiagramType umlDiagramType) {
        String string;
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = this.isThereALinkFromOrToGroup(collection);
        boolean bl4 = graphvizVersion.useProtectionWhenThereALinkFromOrToGroup();
        if (!bl4) {
            bl3 = false;
        }
        if (bl3) {
            this.subgraphCluster(stringBuilder, "a");
        }
        if (bl = this.hasEntryOrExitPoint()) {
            for (Line line : collection) {
                if (!line.isLinkFromOrTo(this.group)) continue;
                line.setProjectionCluster(this);
            }
        }
        boolean bl5 = this.protection0(umlDiagramType);
        boolean bl6 = this.protection1(umlDiagramType);
        if (bl || !bl4) {
            bl5 = false;
            bl6 = false;
        }
        if (bl5) {
            this.subgraphCluster(stringBuilder, "p0");
        }
        stringBuilder.append("subgraph " + this.getClusterId() + " {");
        stringBuilder.append("style=solid;");
        stringBuilder.append("color=\"" + StringUtils.getAsHtml(this.color) + "\";");
        if (this.isLabel()) {
            StringBuilder stringBuilder2 = new StringBuilder("<");
            Line.appendTable(stringBuilder2, this.getTitleAndAttributeWidth(), this.getTitleAndAttributeHeight() - 5, this.colorTitle);
            stringBuilder2.append(">");
            string = stringBuilder2.toString();
        } else {
            string = "\"\"";
        }
        if (bl) {
            this.printClusterEntryExit(stringBuilder, stringBounder);
            this.subgraphCluster(stringBuilder, "ee", string);
        } else {
            stringBuilder.append("label=" + string + ";");
            SvekUtils.println(stringBuilder);
        }
        if (bl2) {
            stringBuilder.append(Cluster.getSpecialPointId(this.group) + " [shape=point,width=.01,label=\"\"];");
        }
        if (bl3) {
            this.subgraphCluster(stringBuilder, "i");
        }
        if (bl6) {
            this.subgraphCluster(stringBuilder, "p1");
        }
        if (this.skinParam.useSwimlanes(umlDiagramType)) {
            stringBuilder.append("{rank = source; ");
            stringBuilder.append(this.getSourceInPoint(umlDiagramType));
            stringBuilder.append(" [shape=point,width=.01,label=\"\"];");
            stringBuilder.append(this.getMinPoint(umlDiagramType) + "->" + this.getSourceInPoint(umlDiagramType) + "  [weight=999];");
            stringBuilder.append("}");
            SvekUtils.println(stringBuilder);
            stringBuilder.append("{rank = sink; ");
            stringBuilder.append(this.getSinkInPoint(umlDiagramType));
            stringBuilder.append(" [shape=point,width=.01,label=\"\"];");
            stringBuilder.append("}");
            stringBuilder.append(this.getSinkInPoint(umlDiagramType) + "->" + this.getMaxPoint(umlDiagramType) + "  [weight=999];");
            SvekUtils.println(stringBuilder);
        }
        SvekUtils.println(stringBuilder);
        this.printCluster1(stringBuilder, collection, stringBounder);
        boolean bl7 = this.printCluster2(stringBuilder, collection, stringBounder, dotMode, graphvizVersion, umlDiagramType);
        if (bl && !bl7) {
            String string2 = "empty" + this.color;
            stringBuilder.append(string2 + " [shape=point,width=.01,label=\"\"];");
        }
        stringBuilder.append("}");
        if (bl6) {
            stringBuilder.append("}");
        }
        if (bl3) {
            stringBuilder.append("}");
            stringBuilder.append("}");
        }
        if (bl) {
            stringBuilder.append("}");
        }
        if (bl5) {
            stringBuilder.append("}");
        }
        SvekUtils.println(stringBuilder);
    }

    public boolean isLabel() {
        return this.getTitleAndAttributeHeight() > 0 && this.getTitleAndAttributeWidth() > 0;
    }

    private void subgraphCluster(StringBuilder stringBuilder, String string) {
        this.subgraphCluster(stringBuilder, string, "\"\"");
    }

    private void subgraphCluster(StringBuilder stringBuilder, String string, String string2) {
        String string3 = this.getClusterId() + string;
        stringBuilder.append("subgraph " + string3 + " {");
        stringBuilder.append("label=" + string2 + ";");
    }

    public int getColor() {
        return this.color;
    }

    public int getTitleColor() {
        return this.colorTitle;
    }

    private final HtmlColor getBackColor(UmlDiagramType umlDiagramType) {
        if (EntityUtils.groupRoot(this.group)) {
            return null;
        }
        HtmlColor htmlColor = this.group.getColors(this.skinParam).getColor(ColorType.BACK);
        if (htmlColor != null) {
            return htmlColor;
        }
        Stereotype stereotype = this.group.getStereotype();
        USymbol uSymbol = this.group.getUSymbol() == null ? USymbol.PACKAGE : this.group.getUSymbol();
        ColorParam colorParam = umlDiagramType == UmlDiagramType.ACTIVITY ? ColorParam.partitionBackground : uSymbol.getColorParamBack();
        HtmlColor htmlColor2 = this.skinParam.getHtmlColor(colorParam, stereotype, false);
        if (htmlColor2 != null) {
            return htmlColor2;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getBackColor(umlDiagramType);
    }

    public boolean isClusterOf(IEntity iEntity) {
        if (!iEntity.isGroup()) {
            return false;
        }
        return this.group == iEntity;
    }

    public static HtmlColor getBackColor(HtmlColor htmlColor, ISkinParam iSkinParam, Stereotype stereotype) {
        if (htmlColor == null) {
            htmlColor = iSkinParam.getHtmlColor(ColorParam.packageBackground, stereotype, false);
        }
        if (htmlColor == null) {
            htmlColor = iSkinParam.getHtmlColor(ColorParam.background, stereotype, false);
        }
        if (htmlColor == null) {
            htmlColor = new HtmlColorTransparent();
        }
        return htmlColor;
    }

    public double checkFolderPosition(Point2D point2D, StringBounder stringBounder) {
        if (this.getClusterPosition().isPointJustUpper(point2D)) {
            if (this.ztitle == null) {
                return 0.0;
            }
            Dimension2D dimension2D = this.ztitle.calculateDimension(stringBounder);
            if (point2D.getX() < this.getClusterPosition().getMinX() + dimension2D.getWidth()) {
                return 0.0;
            }
            return this.getClusterPosition().getMinY() - point2D.getY() + dimension2D.getHeight();
        }
        return 0.0;
    }
}

