/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.posimo.BezierUtils;
import znaishaded.net.sourceforge.plantuml.svek.PointDirected;
import znaishaded.net.sourceforge.plantuml.svek.Side;

public class ClusterPosition {
    private final double minX;
    private final double minY;
    private final double maxX;
    private final double maxY;

    public ClusterPosition(double d, double d2, double d3, double d4) {
        this.minX = d;
        this.minY = d2;
        this.maxX = d3;
        this.maxY = d4;
    }

    public boolean contains(double d, double d2) {
        return d >= this.minX && d < this.maxX && d2 >= this.minY && d2 < this.maxY;
    }

    public ClusterPosition merge(ClusterPosition clusterPosition) {
        return new ClusterPosition(Math.min(this.minX, clusterPosition.minX), Math.min(this.minY, clusterPosition.minY), Math.max(this.maxX, clusterPosition.maxX), Math.max(this.maxY, clusterPosition.maxY));
    }

    public ClusterPosition merge(Point2D point2D) {
        double d = point2D.getX();
        double d2 = point2D.getY();
        return new ClusterPosition(Math.min(this.minX, d), Math.min(this.minY, d2), Math.max(this.maxX, d), Math.max(this.maxY, d2));
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public String toString() {
        return "minX=" + this.minX + " maxX=" + this.maxX + " minY=" + this.minY + " maxY=" + this.maxY;
    }

    public final double getMinX() {
        return this.minX;
    }

    public final double getMinY() {
        return this.minY;
    }

    public final double getMaxX() {
        return this.maxX;
    }

    public final double getMaxY() {
        return this.maxY;
    }

    public PointDirected getIntersection(CubicCurve2D.Double double_) {
        if (this.contains(double_.x1, double_.y1) == this.contains(double_.x2, double_.y2)) {
            return null;
        }
        double d = double_.getP1().distance(double_.getP2());
        if (d < 2.0) {
            double d2 = BezierUtils.getStartingAngle(double_);
            return new PointDirected(double_.getP1(), d2);
        }
        CubicCurve2D.Double double_2 = new CubicCurve2D.Double();
        CubicCurve2D.Double double_3 = new CubicCurve2D.Double();
        double_.subdivide(double_2, double_3);
        PointDirected pointDirected = this.getIntersection(double_2);
        if (pointDirected != null) {
            return pointDirected;
        }
        PointDirected pointDirected2 = this.getIntersection(double_3);
        if (pointDirected2 != null) {
            return pointDirected2;
        }
        throw new IllegalStateException();
    }

    public Point2D getPointCenter() {
        return new Point2D.Double((this.minX + this.maxX) / 2.0, (this.minY + this.maxY) / 2.0);
    }

    public ClusterPosition withMinX(double d) {
        return new ClusterPosition(d, this.minY, this.maxX, this.maxY);
    }

    public ClusterPosition withMaxX(double d) {
        return new ClusterPosition(this.minX, this.minY, d, this.maxY);
    }

    public ClusterPosition addMaxX(double d) {
        return new ClusterPosition(this.minX, this.minY, this.maxX + d, this.maxY);
    }

    public ClusterPosition addMaxY(double d) {
        return new ClusterPosition(this.minX, this.minY, this.maxX, this.maxY + d);
    }

    public ClusterPosition addMinX(double d) {
        return new ClusterPosition(this.minX + d, this.minY, this.maxX, this.maxY);
    }

    public ClusterPosition addMinY(double d) {
        return new ClusterPosition(this.minX, this.minY + d, this.maxX, this.maxY);
    }

    public ClusterPosition withMinY(double d) {
        return new ClusterPosition(this.minX, d, this.maxX, this.maxY);
    }

    public ClusterPosition withMaxY(double d) {
        return new ClusterPosition(this.minX, this.minY, this.maxX, d);
    }

    public Point2D getProjectionOnFrontier(Point2D point2D) {
        double d = point2D.getX();
        double d2 = point2D.getY();
        if (d > this.maxX && d2 >= this.minY && d2 <= this.maxY) {
            return new Point2D.Double(this.maxX - 1.0, d2);
        }
        if (d < this.minX && d2 >= this.minY && d2 <= this.maxY) {
            return new Point2D.Double(this.minX + 1.0, d2);
        }
        if (d2 > this.maxY && d >= this.minX && d <= this.maxX) {
            return new Point2D.Double(d, this.maxY - 1.0);
        }
        if (d2 < this.minY && d >= this.minX && d <= this.maxX) {
            return new Point2D.Double(d, this.minY + 1.0);
        }
        return new Point2D.Double(d, d2);
    }

    public ClusterPosition delta(double d, double d2) {
        return new ClusterPosition(this.minX, this.minY, this.maxX + d, this.maxY + d2);
    }

    public Dimension2D getDimension() {
        return new Dimension2DDouble(this.maxX - this.minX, this.maxY - this.minY);
    }

    public boolean isPointJustUpper(Point2D point2D) {
        return point2D.getX() >= this.minX && point2D.getX() <= this.maxX && point2D.getY() <= this.minY;
    }

    public Side getClosestSide(Point2D point2D) {
        double d;
        double d2 = Math.abs(this.minY - point2D.getY());
        double d3 = Math.abs(this.maxY - point2D.getY());
        double d4 = Math.abs(this.minX - point2D.getX());
        if (this.isSmallerThan(d2, d4, d = Math.abs(this.maxX - point2D.getX()), d3)) {
            return Side.NORTH;
        }
        if (this.isSmallerThan(d3, d2, d4, d)) {
            return Side.SOUTH;
        }
        if (this.isSmallerThan(d, d2, d4, d3)) {
            return Side.EAST;
        }
        if (this.isSmallerThan(d4, d2, d, d3)) {
            return Side.WEST;
        }
        return null;
    }

    private boolean isSmallerThan(double d, double d2, double d3, double d4) {
        return d <= d2 && d <= d3 && d <= d4;
    }
}

