/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.svek.IEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.Margins;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CucaDiagramFileMakerSvek2InternalImage
extends AbstractTextBlock
implements IEntityImage {
    private final List<IEntityImage> inners;
    private final Separator separator;
    private final ISkinParam skinParam;

    private HtmlColor getColor(ColorParam colorParam) {
        return new Rose().getHtmlColor(this.skinParam, colorParam);
    }

    public CucaDiagramFileMakerSvek2InternalImage(List<IEntityImage> list, char c, ISkinParam iSkinParam) {
        this.separator = Separator.fromChar(c);
        this.skinParam = iSkinParam;
        this.inners = list;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        HtmlColor htmlColor = this.getColor(ColorParam.stateBorder);
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.calculateDimension(stringBounder);
        for (int i = 0; i < this.inners.size(); ++i) {
            IEntityImage iEntityImage = this.inners.get(i);
            iEntityImage.drawU(uGraphic);
            Dimension2D dimension2D2 = iEntityImage.calculateDimension(stringBounder);
            uGraphic = uGraphic.apply(this.separator.move(dimension2D2));
            if (i >= this.inners.size() - 1) continue;
            this.separator.drawSeparator(uGraphic.apply(new UChangeColor(htmlColor)), dimension2D);
        }
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = new Dimension2DDouble(0.0, 0.0);
        for (IEntityImage iEntityImage : this.inners) {
            Dimension2D dimension2D2 = iEntityImage.calculateDimension(stringBounder);
            dimension2D = this.separator.add(dimension2D, dimension2D2);
        }
        return dimension2D;
    }

    @Override
    public HtmlColor getBackcolor() {
        return this.skinParam.getBackgroundColor();
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Separator {
        VERTICAL,
        HORIZONTAL;


        static Separator fromChar(char c) {
            if (c == '|') {
                return VERTICAL;
            }
            if (c == '-') {
                return HORIZONTAL;
            }
            throw new IllegalArgumentException();
        }

        UTranslate move(Dimension2D dimension2D) {
            if (this == VERTICAL) {
                return new UTranslate(dimension2D.getWidth(), 0.0);
            }
            return new UTranslate(0.0, dimension2D.getHeight());
        }

        Dimension2D add(Dimension2D dimension2D, Dimension2D dimension2D2) {
            if (this == VERTICAL) {
                return new Dimension2DDouble(dimension2D.getWidth() + dimension2D2.getWidth(), Math.max(dimension2D.getHeight(), dimension2D2.getHeight()));
            }
            return new Dimension2DDouble(Math.max(dimension2D.getWidth(), dimension2D2.getWidth()), dimension2D.getHeight() + dimension2D2.getHeight());
        }

        void drawSeparator(UGraphic uGraphic, Dimension2D dimension2D) {
            uGraphic = uGraphic.apply(new UStroke(8.0, 10.0, 1.5));
            if (this == VERTICAL) {
                uGraphic.draw(new ULine(0.0, dimension2D.getHeight() + 8.0));
            } else {
                uGraphic.draw(new ULine(dimension2D.getWidth() + 8.0, 0.0));
            }
        }
    }
}

