/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.cucadiagram.EntityPosition;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Rankdir;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.Bibliotekon;
import znaishaded.net.sourceforge.plantuml.svek.Cluster;
import znaishaded.net.sourceforge.plantuml.svek.Shape;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageStateBorder
extends AbstractEntityImage {
    private final TextBlock desc;
    private final Cluster stateParent;
    private final EntityPosition entityPosition;
    private final Bibliotekon bibliotekon;
    private final Rankdir rankdir;

    public EntityImageStateBorder(ILeaf iLeaf, ISkinParam iSkinParam, Cluster cluster, Bibliotekon bibliotekon) {
        super(iLeaf, iSkinParam);
        this.bibliotekon = bibliotekon;
        this.rankdir = iSkinParam.getRankdir();
        this.entityPosition = iLeaf.getEntityPosition();
        if (this.entityPosition == EntityPosition.NORMAL) {
            throw new IllegalArgumentException();
        }
        this.stateParent = cluster;
        Stereotype stereotype = iLeaf.getStereotype();
        this.desc = iLeaf.getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.STATE, stereotype), HorizontalAlignment.CENTER, iSkinParam);
    }

    private boolean upPosition() {
        Point2D point2D = this.stateParent.getClusterPosition().getPointCenter();
        Shape shape = this.bibliotekon.getShape(this.getEntity());
        return shape.getMinY() < point2D.getY();
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.entityPosition.getDimension(this.rankdir);
    }

    public double getMaxWidthFromLabelForEntryExit(StringBounder stringBounder) {
        Dimension2D dimension2D = this.desc.calculateDimension(stringBounder);
        return dimension2D.getWidth();
    }

    public final void drawU(UGraphic uGraphic) {
        double d = 0.0;
        Dimension2D dimension2D = this.desc.calculateDimension(uGraphic.getStringBounder());
        double d2 = 0.0 - (dimension2D.getWidth() - 12.0) / 2.0;
        d = this.upPosition() ? (d -= 12.0 + dimension2D.getHeight()) : (d += 12.0);
        this.desc.drawU(uGraphic.apply(new UTranslate(d2, d)));
        uGraphic = uGraphic.apply(new UStroke(1.5)).apply(new UChangeColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stateBorder, this.getStereo())));
        HtmlColor htmlColor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK);
        if (htmlColor == null) {
            htmlColor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stateBackground, this.getStereo());
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(htmlColor));
        this.entityPosition.drawSymbol(uGraphic, this.rankdir);
    }

    public ShapeType getShapeType() {
        return this.entityPosition.getShapeType();
    }
}

