/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.EnsureVisible;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.FontStyle;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.ugraphic.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.UDriver;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UParam;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.UText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverTextAsPathG2d
implements UDriver<Graphics2D> {
    private final EnsureVisible visible;
    private final FontRenderContext fontRenderContext;

    public DriverTextAsPathG2d(EnsureVisible ensureVisible, FontRenderContext fontRenderContext) {
        this.visible = ensureVisible;
        this.fontRenderContext = fontRenderContext;
    }

    private static void printFont() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Log.info("Available fonts: " + stringArray[i]);
        }
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, Graphics2D graphics2D) {
        int n;
        Object object;
        Object object2;
        Object object3;
        UText uText = (UText)uShape;
        FontConfiguration fontConfiguration = uText.getFontConfiguration();
        UFont uFont = fontConfiguration.getFont().scaled(uParam.getScale());
        Dimension2D dimension2D = DriverTextAsPathG2d.calculateDimension(FileFormat.PNG.getDefaultStringBounder(), uFont, uText.getText());
        if (fontConfiguration.containsStyle(FontStyle.BACKCOLOR) && (object3 = colorMapper.getMappedColor(fontConfiguration.getExtendedColor())) != null) {
            graphics2D.setColor((Color)object3);
            graphics2D.setBackground((Color)object3);
            graphics2D.fill(new Rectangle2D.Double(d, d2 - dimension2D.getHeight() + 1.5, dimension2D.getWidth(), dimension2D.getHeight()));
        }
        this.visible.ensureVisible(d, d2 - dimension2D.getHeight() + 1.5);
        this.visible.ensureVisible(d + dimension2D.getWidth(), d2 + 1.5);
        graphics2D.setFont(uFont.getFont());
        graphics2D.setColor(colorMapper.getMappedColor(fontConfiguration.getColor()));
        object3 = new TextLayout(uText.getText(), uFont.getFont(), this.fontRenderContext);
        graphics2D.translate(d, d2);
        graphics2D.fill(((TextLayout)object3).getOutline(null));
        graphics2D.translate(-d, -d2);
        if (fontConfiguration.containsStyle(FontStyle.UNDERLINE)) {
            object2 = fontConfiguration.getExtendedColor();
            if (object2 != null) {
                graphics2D.setColor(colorMapper.getMappedColor((HtmlColor)object2));
            }
            object = DriverTextAsPathG2d.calculateDimension(FileFormat.PNG.getDefaultStringBounder(), uFont, uText.getText());
            n = (int)(d2 + 2.5);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.drawLine((int)d, n, (int)(d + ((Dimension2D)object).getWidth()), n);
            graphics2D.setStroke(new BasicStroke());
        }
        if (fontConfiguration.containsStyle(FontStyle.WAVE)) {
            object2 = DriverTextAsPathG2d.calculateDimension(FileFormat.PNG.getDefaultStringBounder(), uFont, uText.getText());
            int n2 = (int)(d2 + 2.5) - 1;
            HtmlColor htmlColor = fontConfiguration.getExtendedColor();
            if (htmlColor != null) {
                graphics2D.setColor(colorMapper.getMappedColor(htmlColor));
            }
            int n3 = (int)d;
            while ((double)n3 < d + ((Dimension2D)object2).getWidth() - 5.0) {
                graphics2D.drawLine(n3, n2 - 0, n3 + 3, n2 + 1);
                graphics2D.drawLine(n3 + 3, n2 + 1, n3 + 6, n2 - 0);
                n3 += 6;
            }
        }
        if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
            object2 = DriverTextAsPathG2d.calculateDimension(FileFormat.PNG.getDefaultStringBounder(), uFont, uText.getText());
            object = graphics2D.getFontMetrics(uFont.getFont());
            n = (int)(d2 - (double)((FontMetrics)object).getDescent() - 0.5);
            HtmlColor htmlColor = fontConfiguration.getExtendedColor();
            if (htmlColor != null) {
                graphics2D.setColor(colorMapper.getMappedColor(htmlColor));
            }
            graphics2D.setStroke(new BasicStroke(1.5f));
            graphics2D.drawLine((int)d, n, (int)(d + ((Dimension2D)object2).getWidth()), n);
            graphics2D.setStroke(new BasicStroke());
        }
    }

    public static Dimension2D calculateDimension(StringBounder stringBounder, UFont uFont, String string) {
        Dimension2D dimension2D = stringBounder.calculateDimension(uFont, string);
        double d = dimension2D.getHeight();
        if (d < 10.0) {
            d = 10.0;
        }
        return new Dimension2DDouble(dimension2D.getWidth(), d);
    }
}

