/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.http.cookie;

import java.util.Locale;
import znaishaded.org.apache.http.annotation.Contract;
import znaishaded.org.apache.http.annotation.ThreadingBehavior;
import znaishaded.org.apache.http.util.Args;
import znaishaded.org.apache.http.util.TextUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class CookieOrigin {
    private final String host;
    private final int port;
    private final String path;
    private final boolean secure;

    public CookieOrigin(String host, int port2, String path2, boolean secure) {
        Args.notBlank(host, "Host");
        Args.notNegative(port2, "Port");
        Args.notNull(path2, "Path");
        this.host = host.toLowerCase(Locale.ROOT);
        this.port = port2;
        this.path = !TextUtils.isBlank(path2) ? path2 : "/";
        this.secure = secure;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        if (this.secure) {
            buffer.append("(secure)");
        }
        buffer.append(this.host);
        buffer.append(':');
        buffer.append(Integer.toString(this.port));
        buffer.append(this.path);
        buffer.append(']');
        return buffer.toString();
    }
}

