/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.tools.ant.types.resources.selectors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import znaishaded.org.apache.tools.ant.BuildException;
import znaishaded.org.apache.tools.ant.Project;
import znaishaded.org.apache.tools.ant.types.DataType;
import znaishaded.org.apache.tools.ant.types.resources.selectors.ResourceSelector;

public class ResourceSelectorContainer
extends DataType {
    private final List<ResourceSelector> resourceSelectors = new ArrayList<ResourceSelector>();

    public ResourceSelectorContainer() {
    }

    public ResourceSelectorContainer(ResourceSelector ... resourceSelectors) {
        for (ResourceSelector rsel : resourceSelectors) {
            this.add(rsel);
        }
    }

    public void add(ResourceSelector s2) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (s2 == null) {
            return;
        }
        this.resourceSelectors.add(s2);
        this.setChecked(false);
    }

    public boolean hasSelectors() {
        if (this.isReference()) {
            return this.getCheckedRef().hasSelectors();
        }
        this.dieOnCircularReference();
        return !this.resourceSelectors.isEmpty();
    }

    public int selectorCount() {
        if (this.isReference()) {
            return this.getCheckedRef().selectorCount();
        }
        this.dieOnCircularReference();
        return this.resourceSelectors.size();
    }

    public Iterator<ResourceSelector> getSelectors() {
        if (this.isReference()) {
            return this.getCheckedRef().getSelectors();
        }
        return this.getResourceSelectors().iterator();
    }

    public List<ResourceSelector> getResourceSelectors() {
        if (this.isReference()) {
            return this.getCheckedRef().getResourceSelectors();
        }
        this.dieOnCircularReference();
        return Collections.unmodifiableList(this.resourceSelectors);
    }

    @Override
    protected void dieOnCircularReference(Stack<Object> stk, Project p) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stk, p);
        } else {
            for (ResourceSelector resourceSelector : this.resourceSelectors) {
                if (!(resourceSelector instanceof DataType)) continue;
                ResourceSelectorContainer.pushAndInvokeCircularReferenceCheck((DataType)((Object)resourceSelector), stk, p);
            }
            this.setChecked(true);
        }
    }

    @Override
    protected ResourceSelectorContainer getCheckedRef() {
        return (ResourceSelectorContainer)super.getCheckedRef();
    }
}

