/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.org.commonmark.internal.ListItemParser;
import znaishaded.org.commonmark.internal.util.Parsing;
import znaishaded.org.commonmark.node.Block;
import znaishaded.org.commonmark.node.BulletList;
import znaishaded.org.commonmark.node.ListBlock;
import znaishaded.org.commonmark.node.ListItem;
import znaishaded.org.commonmark.node.OrderedList;
import znaishaded.org.commonmark.parser.block.AbstractBlockParser;
import znaishaded.org.commonmark.parser.block.AbstractBlockParserFactory;
import znaishaded.org.commonmark.parser.block.BlockContinue;
import znaishaded.org.commonmark.parser.block.BlockParser;
import znaishaded.org.commonmark.parser.block.BlockStart;
import znaishaded.org.commonmark.parser.block.MatchedBlockParser;
import znaishaded.org.commonmark.parser.block.ParserState;

public class ListBlockParser
extends AbstractBlockParser {
    private static Pattern MARKER = Pattern.compile("^([*+-])(?= |\t|$)|^(\\d{1,9})([.)])(?= |\t|$)");
    private final ListBlock block;

    public ListBlockParser(ListBlock block2) {
        this.block = block2;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean canContain(Block block2) {
        return block2 instanceof ListItem;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        return BlockContinue.atIndex(state.getIndex());
    }

    public void setTight(boolean tight) {
        this.block.setTight(tight);
    }

    private static ListData parseListMarker(CharSequence line, int markerIndex, int markerColumn, boolean inParagraph) {
        int columnAfterMarker;
        CharSequence rest = line.subSequence(markerIndex, line.length());
        Matcher matcher = MARKER.matcher(rest);
        if (!matcher.find()) {
            return null;
        }
        ListBlock listBlock = ListBlockParser.createListBlock(matcher);
        int markerLength = matcher.end() - matcher.start();
        int indexAfterMarker = markerIndex + markerLength;
        int contentColumn = columnAfterMarker = markerColumn + markerLength;
        boolean hasContent = false;
        for (int i = indexAfterMarker; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\t') {
                contentColumn += Parsing.columnsToNextTabStop(contentColumn);
                continue;
            }
            if (c == ' ') {
                ++contentColumn;
                continue;
            }
            hasContent = true;
            break;
        }
        if (inParagraph) {
            if (listBlock instanceof OrderedList && ((OrderedList)listBlock).getStartNumber() != 1) {
                return null;
            }
            if (!hasContent) {
                return null;
            }
        }
        if (!hasContent || contentColumn - columnAfterMarker > Parsing.CODE_BLOCK_INDENT) {
            contentColumn = columnAfterMarker + 1;
        }
        return new ListData(listBlock, contentColumn);
    }

    private static ListBlock createListBlock(Matcher matcher) {
        String bullet = matcher.group(1);
        if (bullet != null) {
            BulletList bulletList = new BulletList();
            bulletList.setBulletMarker(bullet.charAt(0));
            return bulletList;
        }
        String digit = matcher.group(2);
        String delim = matcher.group(3);
        OrderedList orderedList = new OrderedList();
        orderedList.setStartNumber(Integer.parseInt(digit));
        orderedList.setDelimiter(delim.charAt(0));
        return orderedList;
    }

    private static boolean listsMatch(ListBlock a, ListBlock b) {
        if (a instanceof BulletList && b instanceof BulletList) {
            return ListBlockParser.equals(Character.valueOf(((BulletList)a).getBulletMarker()), Character.valueOf(((BulletList)b).getBulletMarker()));
        }
        if (a instanceof OrderedList && b instanceof OrderedList) {
            return ListBlockParser.equals(Character.valueOf(((OrderedList)a).getDelimiter()), Character.valueOf(((OrderedList)b).getDelimiter()));
        }
        return false;
    }

    private static boolean equals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    private static class ListData {
        final ListBlock listBlock;
        final int contentColumn;

        ListData(ListBlock listBlock, int contentColumn) {
            this.listBlock = listBlock;
            this.contentColumn = contentColumn;
        }
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            BlockParser matched = matchedBlockParser.getMatchedBlockParser();
            if (state.getIndent() >= Parsing.CODE_BLOCK_INDENT && !(matched instanceof ListBlockParser)) {
                return BlockStart.none();
            }
            int markerIndex = state.getNextNonSpaceIndex();
            int markerColumn = state.getColumn() + state.getIndent();
            boolean inParagraph = matchedBlockParser.getParagraphContent() != null;
            ListData listData = ListBlockParser.parseListMarker(state.getLine(), markerIndex, markerColumn, inParagraph);
            if (listData == null) {
                return BlockStart.none();
            }
            int newColumn = listData.contentColumn;
            ListItemParser listItemParser = new ListItemParser(newColumn - state.getColumn());
            if (!(matched instanceof ListBlockParser) || !ListBlockParser.listsMatch((ListBlock)matched.getBlock(), listData.listBlock)) {
                ListBlockParser listBlockParser = new ListBlockParser(listData.listBlock);
                listBlockParser.setTight(true);
                return BlockStart.of(listBlockParser, listItemParser).atColumn(newColumn);
            }
            return BlockStart.of(listItemParser).atColumn(newColumn);
        }
    }
}

