/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.renderer.html;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import znaishaded.org.commonmark.internal.util.Escaping;

public class HtmlWriter {
    private static final Map<String, String> NO_ATTRIBUTES = Collections.emptyMap();
    private final Appendable buffer;
    private char lastChar = '\u0000';

    public HtmlWriter(Appendable out) {
        this.buffer = out;
    }

    public void raw(String s2) {
        this.append(s2);
    }

    public void text(String text) {
        this.append(Escaping.escapeHtml(text, false));
    }

    public void tag(String name) {
        this.tag(name, NO_ATTRIBUTES);
    }

    public void tag(String name, Map<String, String> attrs) {
        this.tag(name, attrs, false);
    }

    public void tag(String name, Map<String, String> attrs, boolean voidElement) {
        this.append("<");
        this.append(name);
        if (attrs != null && !attrs.isEmpty()) {
            for (Map.Entry<String, String> attrib : attrs.entrySet()) {
                this.append(" ");
                this.append(Escaping.escapeHtml(attrib.getKey(), true));
                this.append("=\"");
                this.append(Escaping.escapeHtml(attrib.getValue(), true));
                this.append("\"");
            }
        }
        if (voidElement) {
            this.append(" /");
        }
        this.append(">");
    }

    public void line() {
        if (this.lastChar != '\u0000' && this.lastChar != '\n') {
            this.append("\n");
        }
    }

    protected void append(String s2) {
        try {
            this.buffer.append(s2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int length = s2.length();
        if (length != 0) {
            this.lastChar = s2.charAt(length - 1);
        }
    }
}

