# Don't Repeat Yourself

Define templates when you need to reuse the same layout.

Suppose you are have to display multiple elements like the following:
\
\
**Name**: John

**Title**: Software Engineer

**Current Project**: BBR
 
**Team**: Team A
\
\
\
**Name**: Sathish

**Title**: Software Engineer

**Current Project**: BBR
 
**Team**: Team A 

# Definition

Instead of copy and pasting, define a template in a separate file.

`Znai` uses the [FreeMarker](http://freemarker.org) template engine.
 
:include-file: templates/job.md


Insert your template using the fenced block syntax. The content inside the fenced block is treated as key/values. 

    ```template templates/job.md
    name: Sathish
    title: Software Engineer
    ```
    
The result is rendered below:

```template templates/job.md
name: Sathish
title: Software Engineer
```

# Inlined

Consider inlined templates if you don't need to pass a lot of parameter text to the template. 

    :include-template: templates/arg-definition.md {name: "Arg Name", description: "Description of the argument"}
    
    :include-template: templates/arg-definition.md {name: "Other Name", optional: true, description: "Yet another description of the argument"}
    
*templates/arg-definition.md*

:include-file: templates/arg-definition.md
    
:include-template: templates/arg-definition.md {name: "Arg Name", description: "Description of the argument"}

:include-template: templates/arg-definition.md {name: "Other Name", optional: true, description: "Yet another description of the argument"}

# External Parameters

Templates can get parameters from an external file.
The file can be either manually created or generated by a script or test.

Consider an external `JSON` file...

:include-file: artifacts/generated-values.json

...and a template like the following:

:include-file: templates/test-artifact.md

You can include a template in your page and make use of parameters from the file:

    :include-template: templates/test-artifact.md {paramsPath: "artifacts/generated-values.json"}
    
:include-template: templates/test-artifact.md {paramsPath: "artifacts/generated-values.json"}

# Loops

You can loop over a list of parameters using [FreeMarker loop](http://freemarker.org/docs/ref_directive_list.html)

Consider an external file...

:include-file: artifacts/names.json

...and this template:  

:include-file: templates/multiple-arg-definition.md


    :include-template: templates/multiple-arg-definition.md {paramsPath: "artifacts/names.json"}

:include-template: templates/multiple-arg-definition.md {paramsPath: "artifacts/names.json"}
