/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.diagrams.graphviz;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Scanner;
import org.testingisdocumenting.znai.debug.ZnaiDebug;
import org.testingisdocumenting.znai.diagrams.graphviz.GraphvizRuntime;

public class InteractiveCmdGraphviz
implements GraphvizRuntime {
    private final OutputStream outputStream;
    private final InputStream inputStream;
    private final String layoutType;

    public InteractiveCmdGraphviz(String layoutType) {
        this.layoutType = layoutType;
        Process process = this.createProcess(layoutType);
        this.inputStream = process.getInputStream();
        this.outputStream = process.getOutputStream();
    }

    @Override
    public String getLayoutType() {
        return this.layoutType;
    }

    @Override
    public String svgFromGv(String gv) {
        ZnaiDebug.debug("generating svg from graphviz:\n" + gv);
        this.write(gv);
        String svg = this.readTill("</svg>");
        ZnaiDebug.debug("generated svg:\n" + svg);
        return svg;
    }

    private String readTill(String endMarker) {
        StringBuilder result = new StringBuilder();
        Scanner scanner = new Scanner(this.inputStream);
        while (scanner.hasNext()) {
            String line = scanner.nextLine();
            if (line.startsWith("Error: <stdin>:")) {
                throw new RuntimeException(line);
            }
            if (line.startsWith("Warning:")) continue;
            result.append(line).append("\n");
            if (!line.contains(endMarker)) continue;
            break;
        }
        return result.toString();
    }

    private void write(String gv) {
        try {
            this.outputStream.write((gv + "\n").getBytes());
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("error processing graphviz:\n" + gv, e);
        }
    }

    private Process createProcess(String layoutType) {
        try {
            String binPath = this.getBinPath(layoutType);
            return new ProcessBuilder(new String[0]).command(binPath, "-Tsvg").redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new RuntimeException("failed to create process for layoutType: " + layoutType, e);
        }
    }

    private String getBinPath(String layoutType) {
        String bin = System.getProperty(layoutType + ".bin");
        return bin != null ? bin : layoutType;
    }
}

