/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.authorization.groups;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.enterprise.authorization.groups.AuthorizationGroupResolutionService;
import znaishaded.org.apache.commons.io.IOUtils;

public class NixAuthorizationGroupResolutionService
implements AuthorizationGroupResolutionService {
    @Override
    public boolean groupContainsUser(String group, String userId) {
        String groups = NixAuthorizationGroupResolutionService.readGroups(userId);
        String[] groupsList = groups.split(" ");
        return Arrays.asList(groupsList).contains(group);
    }

    private static String readGroups(String userId) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("/bin/sh", "-c", "groups " + userId);
            Process process = processBuilder.start();
            String groups = IOUtils.toString(process.getInputStream(), StandardCharsets.UTF_8);
            String error = IOUtils.toString(process.getErrorStream(), StandardCharsets.UTF_8);
            if (!error.isEmpty()) {
                ConsoleOutputs.err(error);
            }
            process.waitFor();
            if (process.exitValue() != 0) {
                return "";
            }
            return groups;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

