/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.api;

import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.extensions.api.ApiParametersJsonParser;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.resources.ResourcesResolver;

public class ApiParametersIncludePlugin
implements IncludePlugin {
    private Path fullPath;

    @Override
    public String id() {
        return "api-parameters";
    }

    @Override
    public IncludePlugin create() {
        return new ApiParametersIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        ResourcesResolver resourcesResolver = componentsRegistry.resourceResolver();
        this.fullPath = resourcesResolver.fullPath(pluginParams.getFreeParam());
        ApiParameters apiParameters = ApiParametersJsonParser.parse(componentsRegistry.markdownParser(), resourcesResolver.textContent(this.fullPath));
        Map<String, Object> props = apiParameters.toMap();
        props.putAll(pluginParams.getOpts().toMap());
        return PluginResult.docElement("ApiParameters", props);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime(this.fullPath));
    }
}

