/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.columns;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.ColonDelimitedKeyValues;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.docelement.DocElement;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class ColumnsFencePlugin
implements FencePlugin {
    private List<MarkupParserResult> columnsParserResult;
    private Path markupPath;
    private MarkupParser parser;

    @Override
    public String id() {
        return "columns";
    }

    @Override
    public FencePlugin create() {
        return new ColumnsFencePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams, String content) {
        this.markupPath = markupPath;
        this.columnsParserResult = new ArrayList<MarkupParserResult>();
        this.parser = componentsRegistry.defaultParser();
        ColonDelimitedKeyValues columnsDefinitions = new ColonDelimitedKeyValues(content);
        DocElement docElement = new DocElement("Columns", "columns", this.buildColumns(columnsDefinitions), "config", pluginParams.getOpts().toMap());
        return PluginResult.docElement(docElement);
    }

    private List<Map<String, Object>> buildColumns(ColonDelimitedKeyValues columnsDefinitions) {
        return Stream.of(columnsDefinitions.get("left"), columnsDefinitions.get("right")).map(this::buildColumn).collect(Collectors.toList());
    }

    private Map<String, Object> buildColumn(String markup) {
        MarkupParserResult parserResult = this.parser.parse(this.markupPath, markup);
        this.columnsParserResult.add(parserResult);
        LinkedHashMap<String, Object> column = new LinkedHashMap<String, Object>();
        column.put("content", parserResult.getDocElement().contentToListOfMaps());
        return column;
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return this.columnsParserResult.stream().flatMap(pr -> pr.getAuxiliaryFiles().stream());
    }

    @Override
    public SearchText textForSearch() {
        String textFromAllColumns = this.columnsParserResult.stream().map(MarkupParserResult::getAllText).collect(Collectors.joining(" "));
        return SearchScore.STANDARD.text(textFromAllColumns);
    }
}

