/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.gen;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.gen.CliConfig;

public class FromReadmeGenerator {
    private static List<Path> readMeFiles;
    private final Path srcRoot;
    private final String sectionId;

    public static void main(String[] args) throws IOException {
        CliConfig cliConfig = new CliConfig(args);
        FromReadmeGenerator gen = new FromReadmeGenerator(cliConfig.getReadmeRoot(), cliConfig.getSectionId());
        gen.generate(cliConfig.getZnaiDest());
    }

    private FromReadmeGenerator(Path srcRoot, String sectionId) {
        this.srcRoot = srcRoot;
        this.sectionId = sectionId;
    }

    private void generate(Path znaiDest) throws IOException {
        Path znaiSectionPath = znaiDest.resolve(this.sectionId);
        readMeFiles = this.listReadMeFiles(this.srcRoot);
        this.copyMarkdowns(znaiSectionPath);
        String toc = this.generateToc();
        Files.write(znaiDest.resolve("toc"), toc.getBytes(), new OpenOption[0]);
        System.out.println("generated toc:");
        System.out.println(toc);
    }

    private void copyMarkdowns(Path dest) throws IOException {
        readMeFiles.forEach(readMe -> {
            Path destFile = dest.resolve(readMe.getParent().getFileName() + ".md");
            try {
                Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
                Files.copy(readMe, destFile, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private String generateToc() {
        return this.sectionId + "\n" + readMeFiles.stream().map(p -> "    " + p.getParent().getFileName().toString()).collect(Collectors.joining("\n"));
    }

    private List<Path> listReadMeFiles(Path srcRoot) throws IOException {
        return Files.list(srcRoot).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(p -> p.resolve("README.md")).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toList());
    }
}

