/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.parser.commonmark;

import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.Plugins;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.parser.commonmark.include.IncludeBlock;
import org.testingisdocumenting.znai.parser.table.GfmTableToTableConverter;
import org.testingisdocumenting.znai.reference.DocReferences;
import znaishaded.org.commonmark.ext.front.matter.YamlFrontMatterBlock;
import znaishaded.org.commonmark.ext.gfm.strikethrough.Strikethrough;
import znaishaded.org.commonmark.ext.gfm.tables.TableBlock;
import znaishaded.org.commonmark.node.AbstractVisitor;
import znaishaded.org.commonmark.node.BlockQuote;
import znaishaded.org.commonmark.node.BulletList;
import znaishaded.org.commonmark.node.Code;
import znaishaded.org.commonmark.node.CustomBlock;
import znaishaded.org.commonmark.node.CustomNode;
import znaishaded.org.commonmark.node.Emphasis;
import znaishaded.org.commonmark.node.FencedCodeBlock;
import znaishaded.org.commonmark.node.HardLineBreak;
import znaishaded.org.commonmark.node.Heading;
import znaishaded.org.commonmark.node.Image;
import znaishaded.org.commonmark.node.IndentedCodeBlock;
import znaishaded.org.commonmark.node.Link;
import znaishaded.org.commonmark.node.ListItem;
import znaishaded.org.commonmark.node.Node;
import znaishaded.org.commonmark.node.OrderedList;
import znaishaded.org.commonmark.node.Paragraph;
import znaishaded.org.commonmark.node.SoftLineBreak;
import znaishaded.org.commonmark.node.StrongEmphasis;
import znaishaded.org.commonmark.node.Text;
import znaishaded.org.commonmark.node.ThematicBreak;

public class MarkdownVisitor
extends AbstractVisitor {
    private static final Pattern INLINED_CODE_ID_PATTERN = Pattern.compile("^:([a-zA-Z-_]+):\\s*(.*)");
    private final ComponentsRegistry componentsRegistry;
    private final Path path;
    private final ParserHandler parserHandler;
    private boolean sectionStarted;

    public MarkdownVisitor(ComponentsRegistry componentsRegistry, Path path2, ParserHandler parserHandler) {
        this.componentsRegistry = componentsRegistry;
        this.path = path2;
        this.parserHandler = parserHandler;
    }

    public boolean isSectionStarted() {
        return this.sectionStarted;
    }

    @Override
    public void visit(Paragraph paragraph) {
        this.parserHandler.onParagraphStart();
        this.visitChildren(paragraph);
        this.parserHandler.onParagraphEnd();
    }

    @Override
    public void visit(Emphasis emphasis) {
        this.parserHandler.onEmphasisStart();
        this.visitChildren(emphasis);
        this.parserHandler.onEmphasisEnd();
    }

    @Override
    public void visit(StrongEmphasis strongEmphasis) {
        this.parserHandler.onStrongEmphasisStart();
        this.visitChildren(strongEmphasis);
        this.parserHandler.onStrongEmphasisEnd();
    }

    @Override
    public void visit(Text text) {
        this.parserHandler.onSimpleText(text.getLiteral());
    }

    @Override
    public void visit(BulletList bulletList) {
        this.parserHandler.onBulletListStart(bulletList.getBulletMarker(), bulletList.isTight());
        this.visitChildren(bulletList);
        this.parserHandler.onBulletListEnd();
    }

    @Override
    public void visit(OrderedList orderedList) {
        this.parserHandler.onOrderedListStart(orderedList.getDelimiter(), orderedList.getStartNumber());
        this.visitChildren(orderedList);
        this.parserHandler.onOrderedListEnd();
    }

    @Override
    public void visit(ListItem listItem) {
        this.parserHandler.onListItemStart();
        this.visitChildren(listItem);
        this.parserHandler.onListItemEnd();
    }

    @Override
    public void visit(Code code) {
        String literal = code.getLiteral();
        Matcher matcher = INLINED_CODE_ID_PATTERN.matcher(literal);
        if (matcher.matches() && Plugins.hasInlinedCodePlugin(matcher.group(1))) {
            this.parserHandler.onInlinedCodePlugin(new PluginParams(matcher.group(1), matcher.group(2)));
        } else {
            this.parserHandler.onInlinedCode(literal, DocReferences.EMPTY);
        }
    }

    @Override
    public void visit(ThematicBreak thematicBreak) {
        this.parserHandler.onThematicBreak();
    }

    @Override
    public void visit(HardLineBreak hardLineBreak) {
        this.parserHandler.onHardLineBreak();
    }

    @Override
    public void visit(SoftLineBreak softLineBreak) {
        this.parserHandler.onSoftLineBreak();
    }

    @Override
    public void visit(BlockQuote blockQuote) {
        this.parserHandler.onBlockQuoteStart();
        this.visitChildren(blockQuote);
        this.parserHandler.onBlockQuoteEnd();
    }

    @Override
    public void visit(CustomBlock customBlock) {
        if (customBlock instanceof YamlFrontMatterBlock) {
            return;
        }
        if (customBlock instanceof IncludeBlock) {
            IncludeBlock includeBlock = (IncludeBlock)customBlock;
            this.handleIncludePlugin(includeBlock.getParams());
        } else if (customBlock instanceof TableBlock) {
            GfmTableToTableConverter gfmTableToTableConverter = new GfmTableToTableConverter(this.componentsRegistry, this.path, (TableBlock)customBlock);
            this.parserHandler.onTable(gfmTableToTableConverter.convert());
        } else {
            throw new UnsupportedOperationException("unsupported custom block: " + customBlock);
        }
    }

    @Override
    public void visit(CustomNode customNode) {
        if (customNode instanceof Strikethrough) {
            this.parserHandler.onStrikeThroughStart();
            this.visitChildren(customNode);
            this.parserHandler.onStrikeThroughEnd();
        } else {
            super.visit(customNode);
        }
    }

    @Override
    public void visit(Image image) {
        Node firstChild = image.getFirstChild();
        String alt = this.extractText(firstChild);
        this.parserHandler.onImage(image.getTitle(), image.getDestination(), alt.isEmpty() ? "image" : alt);
    }

    @Override
    public void visit(IndentedCodeBlock indentedCodeBlock) {
        this.parserHandler.onSnippet(PluginParams.EMPTY, "", "", indentedCodeBlock.getLiteral());
    }

    @Override
    public void visit(FencedCodeBlock fencedCodeBlock) {
        PluginParams pluginParams = MarkdownVisitor.extractFencePluginParams(fencedCodeBlock.getInfo().trim());
        if (Plugins.hasFencePlugin(pluginParams.getPluginId())) {
            FencePlugin fencePlugin = Plugins.fencePluginById(pluginParams.getPluginId());
            PluginResult pluginResult = fencePlugin.process(this.componentsRegistry, this.path, pluginParams, fencedCodeBlock.getLiteral());
            this.parserHandler.onFencePlugin(fencePlugin, pluginResult);
        } else {
            this.parserHandler.onSnippet(pluginParams, pluginParams.getPluginId(), "", fencedCodeBlock.getLiteral());
        }
    }

    @Override
    public void visit(Link link) {
        this.parserHandler.onLinkStart(link.getDestination());
        this.visitChildren(link);
        this.parserHandler.onLinkEnd();
    }

    @Override
    public void visit(Heading heading) {
        if (heading.getLevel() == 1) {
            if (this.sectionStarted) {
                this.parserHandler.onSectionEnd();
            }
            this.parserHandler.onSectionStart(this.extractHeadingText(heading));
            this.sectionStarted = true;
        } else {
            this.parserHandler.onSubHeading(heading.getLevel(), this.extractHeadingText(heading));
        }
    }

    private void handleIncludePlugin(PluginParams params) {
        IncludePlugin includePlugin = Plugins.includePluginById(params.getPluginId());
        PluginResult pluginResult = includePlugin.process(this.componentsRegistry, this.parserHandler, this.path, params);
        this.parserHandler.onIncludePlugin(includePlugin, pluginResult);
    }

    private static PluginParams extractFencePluginParams(String nameAndParams) {
        int firstSpaceIdx = nameAndParams.indexOf(32);
        return firstSpaceIdx == -1 ? new PluginParams(nameAndParams, "") : new PluginParams(nameAndParams.substring(0, firstSpaceIdx), nameAndParams.substring(firstSpaceIdx + 1));
    }

    private String extractHeadingText(Heading heading) {
        Node firstChild = heading.getFirstChild();
        if (firstChild == null) {
            return "";
        }
        if (!(firstChild instanceof Text)) {
            return "<only regular text is supported as part of heading>";
        }
        return this.extractText(firstChild);
    }

    private String extractText(Node node) {
        if (node == null) {
            return "";
        }
        return ((Text)node).getLiteral();
    }
}

