/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.structure;

public class DocUrl {
    private static final String LINK_TO_SECTION_INSTRUCTION = "To refer to a section of a document page use  dir-name/file-name-without-extension#page-section-id. #page-section-id is optional.\nUse #page-section-id to refer to the current page section.\nUse /#section-id to refer the root page of a documentation.\n";
    private String dirName = "";
    private String fileName = "";
    private String anchorId = "";
    private String url;
    private boolean isExternalUrl;
    private boolean isAnchorOnly;
    private boolean isIndexUrl;

    public static DocUrl indexUrl() {
        return new DocUrl(true);
    }

    private DocUrl(boolean isIndexUrl) {
        this.isIndexUrl = isIndexUrl;
    }

    public DocUrl(String dirName, String fileName, String anchorId) {
        this.dirName = dirName;
        this.fileName = fileName;
        this.anchorId = anchorId;
    }

    public DocUrl(String url) {
        boolean handled;
        this.url = url;
        this.validateNoRelative();
        boolean bl = handled = this.handleExternal() || this.handleIndex() || this.handleAnchorOnly() || this.handleLocal();
        if (!handled) {
            throw new IllegalStateException("couldn't parse url: " + url);
        }
    }

    private boolean handleExternal() {
        this.isExternalUrl = this.url.startsWith("http") || this.url.startsWith("file") || this.url.startsWith("mailto");
        return this.isExternalUrl;
    }

    private boolean handleIndex() {
        if (this.url.startsWith("/#")) {
            this.isIndexUrl = true;
            this.anchorId = this.url.substring(2);
            return true;
        }
        this.isIndexUrl = this.url.equals("/");
        return this.isIndexUrl;
    }

    private boolean handleAnchorOnly() {
        this.isAnchorOnly = this.url.startsWith("#");
        if (this.isAnchorOnly) {
            this.dirName = "";
            this.fileName = "";
            this.anchorId = this.url.substring(1);
        }
        return this.isAnchorOnly;
    }

    private boolean handleLocal() {
        String[] parts = this.url.split("/");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Unexpected url pattern: " + this.url + ". " + LINK_TO_SECTION_INSTRUCTION);
        }
        this.dirName = parts[0];
        int idxOfAnchorSep = parts[1].indexOf(35);
        this.fileName = idxOfAnchorSep == -1 ? parts[1] : parts[1].substring(0, idxOfAnchorSep);
        this.anchorId = idxOfAnchorSep == -1 ? "" : parts[1].substring(idxOfAnchorSep + 1);
        return true;
    }

    private void validateNoRelative() {
        if (this.url.startsWith("..")) {
            throw new IllegalArgumentException("Do not use .. based urls: " + this.url + ". " + LINK_TO_SECTION_INSTRUCTION);
        }
    }

    public boolean isIndexUrl() {
        return this.isIndexUrl;
    }

    public boolean isExternalUrl() {
        return this.isExternalUrl;
    }

    public boolean isAnchorOnly() {
        return this.isAnchorOnly;
    }

    public String getDirName() {
        return this.dirName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getAnchorId() {
        return this.anchorId;
    }

    public String getAnchorIdWithHash() {
        return this.anchorId.isEmpty() ? "" : "#" + this.anchorId;
    }

    public String getUrl() {
        return this.url;
    }
}

