/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.ctreber.acearth;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import znaishaded.com.ctreber.acearth.ConfigurationACearth;
import znaishaded.com.ctreber.acearth.MapDataReader;
import znaishaded.com.ctreber.acearth.gui.CanvasACearth;
import znaishaded.com.ctreber.acearth.plugins.Plugin;
import znaishaded.com.ctreber.acearth.plugins.markers.Marker;
import znaishaded.com.ctreber.acearth.plugins.markers.PluginMarkers;
import znaishaded.com.ctreber.acearth.projection.Projection;
import znaishaded.com.ctreber.acearth.projection.ProjectionCyl;
import znaishaded.com.ctreber.acearth.projection.ProjectionMerc;
import znaishaded.com.ctreber.acearth.projection.ProjectionOrtho;
import znaishaded.com.ctreber.acearth.renderer.Renderer;
import znaishaded.com.ctreber.acearth.renderer.RowTypeRendererScanBit;
import znaishaded.com.ctreber.acearth.renderer.RowTypeRendererScanDot;
import znaishaded.com.ctreber.acearth.scanbit.BitGeneratorMap;
import znaishaded.com.ctreber.acearth.scanbit.BitGeneratorMapDefault;
import znaishaded.com.ctreber.acearth.scanbit.BitGeneratorMapOrtho;
import znaishaded.com.ctreber.acearth.scandot.DotGeneratorLines;
import znaishaded.com.ctreber.acearth.scandot.DotGeneratorStars;
import znaishaded.com.ctreber.acearth.scandot.ScanDot;
import znaishaded.com.ctreber.acearth.scandot.ScanDotGenerator;
import znaishaded.com.ctreber.acearth.shader.Shader;
import znaishaded.com.ctreber.acearth.shader.ShaderDefault;
import znaishaded.com.ctreber.acearth.shader.ShaderFlat;
import znaishaded.com.ctreber.acearth.shader.ShaderOrtho;
import znaishaded.com.ctreber.acearth.util.Coordinate;
import znaishaded.com.ctreber.acearth.util.SunPositionCalculator;
import znaishaded.com.ctreber.acearth.util.Toolkit;
import znaishaded.com.ctreber.aclib.sort.CTSort;
import znaishaded.com.ctreber.aclib.sort.QuickSort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACearth {
    public static final String VERSION = "1.1";
    public static final String BUILD = "22.11.2002 004";
    private ConfigurationACearth fConf = new ConfigurationACearth();
    private long fCurrentTime;
    private CanvasACearth fCanvas;
    private Coordinate fViewPos;
    private double fViewRotation;
    private List fPlugins = new ArrayList();

    public ACearth(List<Marker> list) {
        this.fPlugins.add(new PluginMarkers(list));
    }

    public void exportPng(OutputStream outputStream) throws IOException {
        this.fCanvas = new CanvasACearth(this, this.fConf.getInt("imageWidth"), this.fConf.getInt("imageHeight"));
        this.update();
        this.fCanvas.saveToImage(outputStream);
    }

    public void update() throws IOException {
        Object object;
        Projection projection = null;
        Shader shader = null;
        BitGeneratorMap bitGeneratorMap = null;
        if (this.fConf.is("projection", "Cylindrical")) {
            projection = new ProjectionCyl();
            bitGeneratorMap = new BitGeneratorMapDefault(projection);
            shader = new ShaderDefault();
        }
        if (this.fConf.is("projection", "Mercator")) {
            projection = new ProjectionMerc();
            bitGeneratorMap = new BitGeneratorMapDefault(projection);
            shader = new ShaderDefault();
        }
        if (this.fConf.is("projection", "Orthographic")) {
            projection = new ProjectionOrtho();
            bitGeneratorMap = new BitGeneratorMapOrtho(projection);
            shader = new ShaderOrtho();
        }
        this.computePositions();
        projection.setImageWidth(this.fConf.getInt("imageWidth"));
        projection.setImageHeight(this.fConf.getInt("imageHeight"));
        projection.setShiftX(this.fConf.getInt("shiftX"));
        projection.setShiftY(this.fConf.getInt("shiftY"));
        projection.setViewMagnification(this.fConf.getDouble("viewMagnification"));
        projection.setViewPos(this.fViewPos);
        projection.setViewRotation(this.fViewRotation);
        bitGeneratorMap.setImageWidth(this.fConf.getInt("imageWidth"));
        bitGeneratorMap.setImageHeight(this.fConf.getInt("imageHeight"));
        bitGeneratorMap.setMapData(MapDataReader.readMapData());
        bitGeneratorMap.generateScanBits();
        ArrayList arrayList = new ArrayList();
        if (this.fConf.getBoolean("starsP")) {
            object = new DotGeneratorStars(this.fConf.getInt("imageWidth"), this.fConf.getInt("imageHeight"), this.fConf.getDouble("starFrequency"), this.fConf.getInt("bigStars"), new Random(this.fCurrentTime));
            ((ScanDotGenerator)object).generateScanDots();
            arrayList.addAll(((ScanDotGenerator)object).getScanDots());
        }
        if (this.fConf.getBoolean("gridP")) {
            object = new DotGeneratorLines(projection, this.fConf.getInt("gridDivision"), this.fConf.getInt("gridPixelDivision"));
            ((ScanDotGenerator)object).generateScanDots();
            arrayList.addAll(((ScanDotGenerator)object).getScanDots());
        }
        object = new QuickSort();
        Object[] objectArray = arrayList.toArray(new ScanDot[0]);
        ((CTSort)object).sort(objectArray);
        if (!this.fConf.getBoolean("shadeP")) {
            shader = new ShaderFlat();
        }
        shader.setProjection(projection);
        shader.setSunPos(this.fConf.getSunPos());
        shader.setDaySideBrightness(this.fConf.getInt("daySideBrightness"));
        shader.setTerminatorDiscontinuity(this.fConf.getInt("terminatorDiscontinuity"));
        shader.setNightSideBrightness(this.fConf.getInt("nightSideBrightness"));
        shader.init();
        Renderer renderer = new Renderer(this.fCanvas);
        RowTypeRendererScanBit rowTypeRendererScanBit = new RowTypeRendererScanBit();
        rowTypeRendererScanBit.setScanBits(bitGeneratorMap.getScanBits());
        renderer.addRowTypeRenderer(rowTypeRendererScanBit);
        RowTypeRendererScanDot rowTypeRendererScanDot = new RowTypeRendererScanDot();
        rowTypeRendererScanDot.setScanDots((ScanDot[])objectArray);
        renderer.addRowTypeRenderer(rowTypeRendererScanDot);
        renderer.setShader(shader);
        renderer.render();
        for (Plugin plugin : this.fPlugins) {
            plugin.setProjection(projection);
            plugin.setRenderTarget(this.fCanvas);
            plugin.setParent(this);
            plugin.render();
        }
    }

    private void computePositions() {
        this.fCurrentTime = this.fConf.getInt("fixedTime") == 0 ? System.currentTimeMillis() : (long)this.fConf.getInt("fixedTime") * 1000L;
        if (this.fConf.getBoolean("sunMovesP")) {
            this.fConf.setSunPos(SunPositionCalculator.getSunPositionOnEarth(this.fCurrentTime));
        }
        if (this.fConf.is("viewPositionType", "Fixed")) {
            this.fViewPos = this.fConf.getViewPos();
        } else if (this.fConf.is("viewPositionType", "Sun-relative")) {
            this.fViewPos = this.getSunRelativePosition();
        } else if (this.fConf.is("viewPositionType", "Orbit")) {
            this.fViewPos = this.getOrbitPosition(this.fCurrentTime);
        } else if (this.fConf.is("viewPositionType", "Random")) {
            this.fViewPos = ACearth.getRandomPosition();
        } else if (this.fConf.is("viewPositionType", "Moon")) {
            this.fViewPos = SunPositionCalculator.getMoonPositionOnEarth(this.fCurrentTime);
        }
        this.fViewRotation = this.fConf.is("viewRotationType", "Galactic") ? Toolkit.degsToRads(this.fConf.getSunPos().getLat() * Math.sin(this.fViewPos.getLong() - this.fConf.getSunPos().getLong())) : this.fConf.getDouble("viewRotation");
    }

    private Coordinate getSunRelativePosition() {
        Coordinate coordinate = this.fConf.getSunPos();
        coordinate.add(this.fConf.getSunPosRel());
        return coordinate;
    }

    private Coordinate getOrbitPosition(long l) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        double d4 = (double)l / (this.fConf.getDouble("orbitPeriod") * 3600.0 * 1000.0) * 2.0 * Math.PI;
        double d5 = Math.cos(d4);
        double d6 = Math.sin(d4);
        double d7 = d5 * d3 - d6 * d;
        double d8 = d6 * d3 + d5 * d;
        d3 = d7;
        d = d8;
        d4 = Toolkit.degsToRads(this.fConf.getDouble("orbitInclination"));
        d5 = Math.cos(d4);
        d6 = Math.sin(d4);
        d7 = d5 * d - d6 * d2;
        d8 = d6 * d + d5 * d2;
        d = d7;
        d2 = d8;
        d4 = (double)l / 8.64E7 * (Math.PI * 2);
        d5 = Math.cos(d4);
        d6 = Math.sin(d4);
        d7 = d5 * d - d6 * d3;
        d8 = d6 * d + d5 * d3;
        d = d7;
        d3 = d8;
        return new Coordinate(Toolkit.radsToDegs(Math.asin(d2)), Toolkit.radsToDegs(Math.atan2(d, d3)));
    }

    private static Coordinate getRandomPosition() {
        int n;
        double[] dArray = new double[3];
        double d = 0.0;
        do {
            for (n = 0; n < 3; ++n) {
                dArray[n] = Math.random() * 20000.0 * 1.0E-4 - 1.0;
                d += dArray[n] * dArray[n];
            }
        } while (d > 1.0 || d < 0.01);
        d = Math.sqrt(d);
        n = 0;
        while (n < 3) {
            int n2 = n++;
            dArray[n2] = dArray[n2] / d;
        }
        double d2 = dArray[1];
        double d3 = Math.sqrt(1.0 - d2 * d2);
        double d4 = dArray[0] / d3;
        double d5 = dArray[2] / d3;
        return new Coordinate(Math.atan2(d2, d3) * 57.29577951308232, Math.atan2(d4, d5) * 57.29577951308232);
    }

    public ConfigurationACearth getConf() {
        return this.fConf;
    }
}

