/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.ctreber.acearth.renderer;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import znaishaded.com.ctreber.acearth.renderer.RenderTarget;
import znaishaded.com.ctreber.acearth.renderer.RowTypeRenderer;
import znaishaded.com.ctreber.acearth.shader.Shader;

public class Renderer {
    private Shader fShader;
    private RenderTarget fRenderTarget;
    private List fRowTypeRenderers = new ArrayList();

    public Renderer(RenderTarget renderTarget) {
        this.fRenderTarget = renderTarget;
    }

    public void render() {
        for (RowTypeRenderer rowTypeRenderer : this.fRowTypeRenderers) {
            rowTypeRenderer.startNewRun();
        }
        this.renderRows();
    }

    private void renderRows() {
        for (int i = 0; i < this.fRenderTarget.getImageHeight(); ++i) {
            int[] nArray = this.getPixelTypes(i);
            this.renderRow(i, nArray);
        }
    }

    private int[] getPixelTypes(int n) {
        int[] nArray = new int[this.fRenderTarget.getImageWidth()];
        for (RowTypeRenderer rowTypeRenderer : this.fRowTypeRenderers) {
            rowTypeRenderer.getPixelTypes(n, nArray);
        }
        return nArray;
    }

    private void renderRow(int n, int[] nArray) {
        Color[] colorArray = this.fShader.getShadedColors(n, nArray);
        for (int i = 0; i < this.fRenderTarget.getImageWidth(); ++i) {
            this.fRenderTarget.setPixel(i, n, colorArray[i]);
        }
    }

    public void setShader(Shader shader) {
        this.fShader = shader;
    }

    public void setRenderTarget(RenderTarget renderTarget) {
        this.fRenderTarget = renderTarget;
    }

    public void addRowTypeRenderer(RowTypeRenderer rowTypeRenderer) {
        this.fRowTypeRenderers.add(rowTypeRenderer);
    }
}

