/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.javaparser;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import znaishaded.com.github.javaparser.ParserConfiguration;
import znaishaded.com.github.javaparser.Problem;
import znaishaded.com.github.javaparser.ast.Node;
import znaishaded.com.github.javaparser.ast.comments.CommentsCollection;
import znaishaded.com.github.javaparser.utils.Utils;

public class ParseResult<T> {
    private final T result;
    private final List<Problem> problems;
    private final CommentsCollection commentsCollection;

    public ParseResult(T result, List<Problem> problems, CommentsCollection commentsCollection) {
        this.commentsCollection = commentsCollection;
        this.result = result;
        this.problems = problems;
    }

    public boolean isSuccessful() {
        return this.problems.isEmpty() && this.result != null;
    }

    public void ifSuccessful(Consumer<T> consumer) {
        if (this.isSuccessful()) {
            consumer.accept(this.result);
        }
    }

    public List<Problem> getProblems() {
        return this.problems;
    }

    public Problem getProblem(int i) {
        return this.getProblems().get(i);
    }

    public Optional<CommentsCollection> getCommentsCollection() {
        return Optional.ofNullable(this.commentsCollection);
    }

    public Optional<T> getResult() {
        return Optional.ofNullable(this.result);
    }

    public String toString() {
        if (this.isSuccessful()) {
            return "Parsing successful";
        }
        StringBuilder message = new StringBuilder("Parsing failed:").append(Utils.EOL);
        for (Problem problem : this.problems) {
            message.append(problem.toString()).append(Utils.EOL);
        }
        return message.toString();
    }

    public static interface PostProcessor {
        public void process(ParseResult<? extends Node> var1, ParserConfiguration var2);
    }
}

