/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.google.zxing.client.j2se;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import znaishaded.com.google.zxing.common.BitMatrix;

public final class MatrixToImageWriter {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;

    private MatrixToImageWriter() {
    }

    public static BufferedImage toBufferedImage(BitMatrix bitMatrix) {
        int n = bitMatrix.getWidth();
        int n2 = bitMatrix.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                bufferedImage.setRGB(i, j, bitMatrix.get(i, j) ? -16777216 : -1);
            }
        }
        return bufferedImage;
    }

    public static void writeToFile(BitMatrix bitMatrix, String string, File file) throws IOException {
        BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage(bitMatrix);
        ImageIO.write((RenderedImage)bufferedImage, string, file);
    }

    public static void writeToStream(BitMatrix bitMatrix, String string, OutputStream outputStream) throws IOException {
        BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage(bitMatrix);
        ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
    }
}

