/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.jayway.jsonpath.spi.mapper;

import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import znaishaded.com.google.gson.Gson;
import znaishaded.com.google.gson.JsonElement;
import znaishaded.com.google.gson.reflect.TypeToken;
import znaishaded.com.jayway.jsonpath.Configuration;
import znaishaded.com.jayway.jsonpath.JsonPathException;
import znaishaded.com.jayway.jsonpath.TypeRef;
import znaishaded.com.jayway.jsonpath.spi.mapper.MappingException;
import znaishaded.com.jayway.jsonpath.spi.mapper.MappingProvider;
import znaishaded.org.slf4j.Logger;
import znaishaded.org.slf4j.LoggerFactory;

public class GsonMappingProvider
implements MappingProvider {
    private static final Logger logger = LoggerFactory.getLogger(GsonMappingProvider.class);
    private final Callable<Gson> factory;

    public GsonMappingProvider(final Gson gson) {
        this(new Callable<Gson>(){

            @Override
            public Gson call() {
                return gson;
            }
        });
    }

    public GsonMappingProvider(Callable<Gson> factory) {
        this.factory = factory;
    }

    public GsonMappingProvider() {
        try {
            Class.forName("znaishaded.com.google.gson.Gson");
            this.factory = new Callable<Gson>(){

                @Override
                public Gson call() {
                    return new Gson();
                }
            };
        }
        catch (ClassNotFoundException e) {
            logger.error("Gson not found on class path. No converters configured.");
            throw new JsonPathException("Gson not found on path", e);
        }
    }

    @Override
    public <T> T map(Object source, Class<T> targetType, Configuration configuration) {
        if (source == null) {
            return null;
        }
        try {
            return (T)this.factory.call().getAdapter(targetType).fromJsonTree((JsonElement)source);
        }
        catch (Exception e) {
            throw new MappingException(e);
        }
    }

    @Override
    public <T> T map(Object source, TypeRef<T> targetType, Configuration configuration) {
        if (source == null) {
            return null;
        }
        try {
            return (T)this.factory.call().getAdapter(TypeToken.get((Type)targetType.getType())).fromJsonTree((JsonElement)source);
        }
        catch (Exception e) {
            throw new MappingException(e);
        }
    }
}

