/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.core;

import java.util.HashSet;
import java.util.Set;
import znaishaded.freemarker.core.ArithmeticEngine;
import znaishaded.freemarker.core.CollectionAndSequence;
import znaishaded.freemarker.core.Environment;
import znaishaded.freemarker.core.EvalUtil;
import znaishaded.freemarker.core.Expression;
import znaishaded.freemarker.core.NonStringException;
import znaishaded.freemarker.core.ParameterRole;
import znaishaded.freemarker.core.TemplateObject;
import znaishaded.freemarker.template.SimpleNumber;
import znaishaded.freemarker.template.SimpleScalar;
import znaishaded.freemarker.template.SimpleSequence;
import znaishaded.freemarker.template.TemplateCollectionModel;
import znaishaded.freemarker.template.TemplateException;
import znaishaded.freemarker.template.TemplateHashModel;
import znaishaded.freemarker.template.TemplateHashModelEx;
import znaishaded.freemarker.template.TemplateModel;
import znaishaded.freemarker.template.TemplateModelException;
import znaishaded.freemarker.template.TemplateModelIterator;
import znaishaded.freemarker.template.TemplateNumberModel;
import znaishaded.freemarker.template.TemplateScalarModel;
import znaishaded.freemarker.template.TemplateSequenceModel;

final class AddConcatExpression
extends Expression {
    private final Expression left;
    private final Expression right;

    AddConcatExpression(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    TemplateModel _eval(Environment env) throws TemplateException {
        return AddConcatExpression._eval(env, this, this.left, this.left.eval(env), this.right, this.right.eval(env));
    }

    static TemplateModel _eval(Environment env, TemplateObject parent, Expression leftExp, TemplateModel leftModel, Expression rightExp, TemplateModel rightModel) throws TemplateModelException, TemplateException, NonStringException {
        if (leftModel instanceof TemplateNumberModel && rightModel instanceof TemplateNumberModel) {
            Number first = EvalUtil.modelToNumber((TemplateNumberModel)leftModel, leftExp);
            Number second = EvalUtil.modelToNumber((TemplateNumberModel)rightModel, rightExp);
            return AddConcatExpression._evalOnNumbers(env, parent, first, second);
        }
        if (leftModel instanceof TemplateSequenceModel && rightModel instanceof TemplateSequenceModel) {
            return new ConcatenatedSequence((TemplateSequenceModel)leftModel, (TemplateSequenceModel)rightModel);
        }
        try {
            String s2;
            String s1 = Expression.coerceModelToString(leftModel, leftExp, env);
            if (s1 == null) {
                s1 = "null";
            }
            if ((s2 = Expression.coerceModelToString(rightModel, rightExp, env)) == null) {
                s2 = "null";
            }
            return new SimpleScalar(s1.concat(s2));
        }
        catch (NonStringException e) {
            if (leftModel instanceof TemplateHashModel && rightModel instanceof TemplateHashModel) {
                if (leftModel instanceof TemplateHashModelEx && rightModel instanceof TemplateHashModelEx) {
                    TemplateHashModelEx leftModelEx = (TemplateHashModelEx)leftModel;
                    TemplateHashModelEx rightModelEx = (TemplateHashModelEx)rightModel;
                    if (leftModelEx.size() == 0) {
                        return rightModelEx;
                    }
                    if (rightModelEx.size() == 0) {
                        return leftModelEx;
                    }
                    return new ConcatenatedHashEx(leftModelEx, rightModelEx);
                }
                return new ConcatenatedHash((TemplateHashModel)leftModel, (TemplateHashModel)rightModel);
            }
            throw e;
        }
    }

    static TemplateModel _evalOnNumbers(Environment env, TemplateObject parent, Number first, Number second) throws TemplateException {
        ArithmeticEngine ae = env != null ? env.getArithmeticEngine() : parent.getTemplate().getArithmeticEngine();
        return new SimpleNumber(ae.add(first, second));
    }

    boolean isLiteral() {
        return this.constantValue != null || this.left.isLiteral() && this.right.isLiteral();
    }

    protected Expression deepCloneWithIdentifierReplaced_inner(String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
        return new AddConcatExpression(this.left.deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState), this.right.deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState));
    }

    public String getCanonicalForm() {
        return this.left.getCanonicalForm() + " + " + this.right.getCanonicalForm();
    }

    String getNodeTypeSymbol() {
        return "+";
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        return idx == 0 ? this.left : this.right;
    }

    ParameterRole getParameterRole(int idx) {
        return ParameterRole.forBinaryOperatorOperand(idx);
    }

    private static final class ConcatenatedHashEx
    extends ConcatenatedHash
    implements TemplateHashModelEx {
        private CollectionAndSequence keys;
        private CollectionAndSequence values;
        private int size;

        ConcatenatedHashEx(TemplateHashModelEx left, TemplateHashModelEx right) {
            super(left, right);
        }

        public int size() throws TemplateModelException {
            this.initKeys();
            return this.size;
        }

        public TemplateCollectionModel keys() throws TemplateModelException {
            this.initKeys();
            return this.keys;
        }

        public TemplateCollectionModel values() throws TemplateModelException {
            this.initValues();
            return this.values;
        }

        private void initKeys() throws TemplateModelException {
            if (this.keys == null) {
                HashSet keySet = new HashSet();
                SimpleSequence keySeq = new SimpleSequence(32);
                ConcatenatedHashEx.addKeys(keySet, keySeq, (TemplateHashModelEx)this.left);
                ConcatenatedHashEx.addKeys(keySet, keySeq, (TemplateHashModelEx)this.right);
                this.size = keySet.size();
                this.keys = new CollectionAndSequence(keySeq);
            }
        }

        private static void addKeys(Set set, SimpleSequence keySeq, TemplateHashModelEx hash) throws TemplateModelException {
            TemplateModelIterator it = hash.keys().iterator();
            while (it.hasNext()) {
                TemplateScalarModel tsm = (TemplateScalarModel)it.next();
                if (!set.add(tsm.getAsString())) continue;
                keySeq.add(tsm);
            }
        }

        private void initValues() throws TemplateModelException {
            if (this.values == null) {
                SimpleSequence seq = new SimpleSequence(this.size());
                int ln = this.keys.size();
                for (int i = 0; i < ln; ++i) {
                    seq.add(this.get(((TemplateScalarModel)this.keys.get(i)).getAsString()));
                }
                this.values = new CollectionAndSequence(seq);
            }
        }
    }

    private static class ConcatenatedHash
    implements TemplateHashModel {
        protected final TemplateHashModel left;
        protected final TemplateHashModel right;

        ConcatenatedHash(TemplateHashModel left, TemplateHashModel right) {
            this.left = left;
            this.right = right;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            TemplateModel model = this.right.get(key);
            return model != null ? model : this.left.get(key);
        }

        public boolean isEmpty() throws TemplateModelException {
            return this.left.isEmpty() && this.right.isEmpty();
        }
    }

    private static final class ConcatenatedSequence
    implements TemplateSequenceModel {
        private final TemplateSequenceModel left;
        private final TemplateSequenceModel right;

        ConcatenatedSequence(TemplateSequenceModel left, TemplateSequenceModel right) {
            this.left = left;
            this.right = right;
        }

        public int size() throws TemplateModelException {
            return this.left.size() + this.right.size();
        }

        public TemplateModel get(int i) throws TemplateModelException {
            int ls = this.left.size();
            return i < ls ? this.left.get(i) : this.right.get(i - ls);
        }
    }
}

