/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.core;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import znaishaded.freemarker.core.APINotSupportedTemplateException;
import znaishaded.freemarker.core.BugException;
import znaishaded.freemarker.core.BuiltIn;
import znaishaded.freemarker.core.Environment;
import znaishaded.freemarker.core.EvalUtil;
import znaishaded.freemarker.core.Expression;
import znaishaded.freemarker.core.ICIChainMember;
import znaishaded.freemarker.core.Macro;
import znaishaded.freemarker.core.MessageUtil;
import znaishaded.freemarker.core.TemplateDateFormat;
import znaishaded.freemarker.core.UnexpectedTypeException;
import znaishaded.freemarker.core.UnformattableDateException;
import znaishaded.freemarker.core._DelayedJQuote;
import znaishaded.freemarker.core._MiscTemplateException;
import znaishaded.freemarker.core._TemplateModelException;
import znaishaded.freemarker.ext.beans.BeanModel;
import znaishaded.freemarker.ext.beans.OverloadedMethodsModel;
import znaishaded.freemarker.ext.beans.SimpleMethodModel;
import znaishaded.freemarker.ext.beans._BeansAPI;
import znaishaded.freemarker.template.SimpleDate;
import znaishaded.freemarker.template.SimpleNumber;
import znaishaded.freemarker.template.SimpleScalar;
import znaishaded.freemarker.template.TemplateBooleanModel;
import znaishaded.freemarker.template.TemplateCollectionModel;
import znaishaded.freemarker.template.TemplateCollectionModelEx;
import znaishaded.freemarker.template.TemplateDateModel;
import znaishaded.freemarker.template.TemplateDirectiveModel;
import znaishaded.freemarker.template.TemplateException;
import znaishaded.freemarker.template.TemplateHashModel;
import znaishaded.freemarker.template.TemplateHashModelEx;
import znaishaded.freemarker.template.TemplateMethodModel;
import znaishaded.freemarker.template.TemplateModel;
import znaishaded.freemarker.template.TemplateModelException;
import znaishaded.freemarker.template.TemplateModelWithAPISupport;
import znaishaded.freemarker.template.TemplateNodeModel;
import znaishaded.freemarker.template.TemplateNumberModel;
import znaishaded.freemarker.template.TemplateScalarModel;
import znaishaded.freemarker.template.TemplateSequenceModel;
import znaishaded.freemarker.template.TemplateTransformModel;
import znaishaded.freemarker.template._TemplateAPI;

class BuiltInsForMultipleTypes {
    static /* synthetic */ Class class$freemarker$template$TemplateNumberModel;
    static /* synthetic */ Class class$freemarker$template$TemplateBooleanModel;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$freemarker$core$Macro;
    static /* synthetic */ Class class$freemarker$template$TemplateHashModelEx;
    static /* synthetic */ Class class$freemarker$template$TemplateSequenceModel;
    static /* synthetic */ Class class$freemarker$template$TemplateCollectionModelEx;
    static /* synthetic */ Class class$freemarker$template$TemplateDateModel;
    static /* synthetic */ Class class$freemarker$template$TemplateScalarModel;

    private BuiltInsForMultipleTypes() {
    }

    static abstract class AbstractCBI
    extends BuiltIn {
        AbstractCBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel model = this.target.eval(env);
            if (model instanceof TemplateNumberModel) {
                return this.formatNumber(env, model);
            }
            if (model instanceof TemplateBooleanModel) {
                return new SimpleScalar(((TemplateBooleanModel)model).getAsBoolean() ? "true" : "false");
            }
            throw new UnexpectedTypeException(this.target, model, "number or boolean", new Class[]{class$freemarker$template$TemplateNumberModel == null ? (class$freemarker$template$TemplateNumberModel = BuiltInsForMultipleTypes.class$("znaishaded.freemarker.template.TemplateNumberModel")) : class$freemarker$template$TemplateNumberModel, class$freemarker$template$TemplateBooleanModel == null ? (class$freemarker$template$TemplateBooleanModel = BuiltInsForMultipleTypes.class$("znaishaded.freemarker.template.TemplateBooleanModel")) : class$freemarker$template$TemplateBooleanModel}, env);
        }

        protected abstract TemplateModel formatNumber(Environment var1, TemplateModel var2) throws TemplateModelException;
    }

    static class stringBI
    extends BuiltIn {
        stringBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel model = this.target.eval(env);
            if (model instanceof TemplateNumberModel) {
                return new NumberFormatter(EvalUtil.modelToNumber((TemplateNumberModel)model, this.target), env);
            }
            if (model instanceof TemplateDateModel) {
                TemplateDateModel dm = (TemplateDateModel)model;
                return new DateFormatter(dm, env);
            }
            if (model instanceof SimpleScalar) {
                return model;
            }
            if (model instanceof TemplateBooleanModel) {
                return new BooleanFormatter((TemplateBooleanModel)model, env);
            }
            if (model instanceof TemplateScalarModel) {
                return new SimpleScalar(((TemplateScalarModel)model).getAsString());
            }
            if (env.isClassicCompatible() && model instanceof BeanModel) {
                return new SimpleScalar(_BeansAPI.getAsClassicCompatibleString((BeanModel)model));
            }
            throw new UnexpectedTypeException(this.target, model, "number, date, boolean or string", new Class[]{class$freemarker$template$TemplateNumberModel == null ? (class$freemarker$template$TemplateNumberModel = BuiltInsForMultipleTypes.class$("znaishaded.freemarker.template.TemplateNumberModel")) : class$freemarker$template$TemplateNumberModel, class$freemarker$template$TemplateDateModel == null ? (class$freemarker$template$TemplateDateModel = BuiltInsForMultipleTypes.class$("znaishaded.freemarker.template.TemplateDateModel")) : class$freemarker$template$TemplateDateModel, class$freemarker$template$TemplateBooleanModel == null ? (class$freemarker$template$TemplateBooleanModel = BuiltInsForMultipleTypes.class$("znaishaded.freemarker.template.TemplateBooleanModel")) : class$freemarker$template$TemplateBooleanModel, class$freemarker$template$TemplateScalarModel == null ? (class$freemarker$template$TemplateScalarModel = BuiltInsForMultipleTypes.class$("znaishaded.freemarker.template.TemplateScalarModel")) : class$freemarker$template$TemplateScalarModel}, env);
        }

        private class NumberFormatter
        implements TemplateScalarModel,
        TemplateHashModel,
        TemplateMethodModel {
            private final Number number;
            private final Environment env;
            private final NumberFormat defaultFormat;
            private String cachedValue;

            NumberFormatter(Number number, Environment env) {
                this.number = number;
                this.env = env;
                this.defaultFormat = env.getNumberFormatObject(env.getNumberFormat());
            }

            public Object exec(List args) throws TemplateModelException {
                stringBI.this.checkMethodArgCount(args, 1);
                return this.get((String)args.get(0));
            }

            public TemplateModel get(String key) {
                return new SimpleScalar(this.env.getNumberFormatObject(key).format(this.number));
            }

            public String getAsString() {
                if (this.cachedValue == null) {
                    this.cachedValue = this.defaultFormat.format(this.number);
                }
                return this.cachedValue;
            }

            public boolean isEmpty() {
                return false;
            }
        }

        private class DateFormatter
        implements TemplateScalarModel,
        TemplateHashModel,
        TemplateMethodModel {
            private final TemplateDateModel dateModel;
            private final Environment env;
            private final TemplateDateFormat defaultFormat;
            private String cachedValue;

            DateFormatter(TemplateDateModel dateModel, Environment env) throws TemplateModelException {
                this.dateModel = dateModel;
                this.env = env;
                int dateType = dateModel.getDateType();
                this.defaultFormat = dateType == 0 ? null : env.getTemplateDateFormat(dateType, EvalUtil.modelToDate(dateModel, stringBI.this.target).getClass(), stringBI.this.target);
            }

            public Object exec(List args) throws TemplateModelException {
                stringBI.this.checkMethodArgCount(args, 1);
                return this.get((String)args.get(0));
            }

            public TemplateModel get(String key) throws TemplateModelException {
                return new SimpleScalar(this.env.formatDate(this.dateModel, key, stringBI.this.target));
            }

            public String getAsString() throws TemplateModelException {
                if (this.cachedValue == null) {
                    try {
                        if (this.defaultFormat == null) {
                            if (this.dateModel.getDateType() == 0) {
                                throw MessageUtil.newCantFormatUnknownTypeDateException(stringBI.this.target, null);
                            }
                            throw new BugException();
                        }
                        this.cachedValue = this.defaultFormat.format(this.dateModel);
                    }
                    catch (UnformattableDateException e) {
                        throw MessageUtil.newCantFormatDateException(stringBI.this.target, e);
                    }
                }
                return this.cachedValue;
            }

            public boolean isEmpty() {
                return false;
            }
        }

        private class BooleanFormatter
        implements TemplateScalarModel,
        TemplateMethodModel {
            private final TemplateBooleanModel bool;
            private final Environment env;

            BooleanFormatter(TemplateBooleanModel bool, Environment env) {
                this.bool = bool;
                this.env = env;
            }

            public Object exec(List args) throws TemplateModelException {
                stringBI.this.checkMethodArgCount(args, 2);
                return new SimpleScalar((String)args.get(this.bool.getAsBoolean() ? 0 : 1));
            }

            public String getAsString() throws TemplateModelException {
                if (this.bool instanceof TemplateScalarModel) {
                    return ((TemplateScalarModel)((Object)this.bool)).getAsString();
                }
                try {
                    return this.env.formatBoolean(this.bool.getAsBoolean(), true);
                }
                catch (TemplateException e) {
                    throw new TemplateModelException(e);
                }
            }
        }
    }

    static class sizeBI
    extends BuiltIn {
        sizeBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            int size;
            TemplateModel model = this.target.eval(env);
            if (model instanceof TemplateSequenceModel) {
                size = ((TemplateSequenceModel)model).size();
            } else if (model instanceof TemplateCollectionModelEx) {
                size = ((TemplateCollectionModelEx)model).size();
            } else if (model instanceof TemplateHashModelEx) {
                size = ((TemplateHashModelEx)model).size();
            } else {
                throw new UnexpectedTypeException(this.target, model, "extended-hash or sequence or extended collection", new Class[]{class$freemarker$template$TemplateHashModelEx == null ? (class$freemarker$template$TemplateHashModelEx = BuiltInsForMultipleTypes.class$("znaishaded.freemarker.template.TemplateHashModelEx")) : class$freemarker$template$TemplateHashModelEx, class$freemarker$template$TemplateSequenceModel == null ? (class$freemarker$template$TemplateSequenceModel = BuiltInsForMultipleTypes.class$("znaishaded.freemarker.template.TemplateSequenceModel")) : class$freemarker$template$TemplateSequenceModel, class$freemarker$template$TemplateCollectionModelEx == null ? (class$freemarker$template$TemplateCollectionModelEx = BuiltInsForMultipleTypes.class$("znaishaded.freemarker.template.TemplateCollectionModelEx")) : class$freemarker$template$TemplateCollectionModelEx}, env);
            }
            return new SimpleNumber(size);
        }
    }

    static class namespaceBI
    extends BuiltIn {
        namespaceBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            if (!(tm instanceof Macro)) {
                throw new UnexpectedTypeException(this.target, tm, "macro or function", new Class[]{class$freemarker$core$Macro == null ? (class$freemarker$core$Macro = BuiltInsForMultipleTypes.class$("znaishaded.freemarker.core.Macro")) : class$freemarker$core$Macro}, env);
            }
            return env.getMacroNamespace((Macro)tm);
        }
    }

    static class is_transformBI
    extends BuiltIn {
        is_transformBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateTransformModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_stringBI
    extends BuiltIn {
        is_stringBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateScalarModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_sequenceBI
    extends BuiltIn {
        is_sequenceBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateSequenceModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_numberBI
    extends BuiltIn {
        is_numberBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateNumberModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_nodeBI
    extends BuiltIn {
        is_nodeBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateNodeModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_methodBI
    extends BuiltIn {
        is_methodBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateMethodModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_macroBI
    extends BuiltIn {
        is_macroBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof Macro ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_indexableBI
    extends BuiltIn {
        is_indexableBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateSequenceModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_hashBI
    extends BuiltIn {
        is_hashBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateHashModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_hash_exBI
    extends BuiltIn {
        is_hash_exBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateHashModelEx ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_enumerableBI
    extends BuiltIn {
        is_enumerableBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return (tm instanceof TemplateSequenceModel || tm instanceof TemplateCollectionModel) && (_TemplateAPI.getTemplateLanguageVersionAsInt(this) < _TemplateAPI.VERSION_INT_2_3_21 || !(tm instanceof SimpleMethodModel) && !(tm instanceof OverloadedMethodsModel)) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_directiveBI
    extends BuiltIn {
        is_directiveBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateTransformModel || tm instanceof Macro || tm instanceof TemplateDirectiveModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_dateOfTypeBI
    extends BuiltIn {
        private final int dateType;

        is_dateOfTypeBI(int dateType) {
            this.dateType = dateType;
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateDateModel && ((TemplateDateModel)tm).getDateType() == this.dateType ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_dateLikeBI
    extends BuiltIn {
        is_dateLikeBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateDateModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_collection_exBI
    extends BuiltIn {
        is_collection_exBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateCollectionModelEx ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_collectionBI
    extends BuiltIn {
        is_collectionBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateCollectionModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_booleanBI
    extends BuiltIn {
        is_booleanBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateBooleanModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class has_apiBI
    extends BuiltIn {
        has_apiBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateModelWithAPISupport ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class apiBI
    extends BuiltIn {
        apiBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            if (!env.isAPIBuiltinEnabled()) {
                throw new _MiscTemplateException((Expression)this, new Object[]{"Can't use ?api, because the \"", "api_builtin_enabled", "\" configuration setting is false. Think twice before you set it to true though. Especially, it shouldn't abussed for modifying Map-s and Collection-s."});
            }
            TemplateModel tm = this.target.eval(env);
            if (!(tm instanceof TemplateModelWithAPISupport)) {
                this.target.assertNonNull(tm, env);
                throw new APINotSupportedTemplateException(env, this.target, tm);
            }
            return ((TemplateModelWithAPISupport)tm).getAPI();
        }
    }

    static class dateBI
    extends BuiltIn {
        private final int dateType;

        dateBI(int dateType) {
            this.dateType = dateType;
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel model = this.target.eval(env);
            if (model instanceof TemplateDateModel) {
                TemplateDateModel dmodel = (TemplateDateModel)model;
                int dtype = dmodel.getDateType();
                if (this.dateType == dtype) {
                    return model;
                }
                if (dtype == 0 || dtype == 3) {
                    return new SimpleDate(dmodel.getAsDate(), this.dateType);
                }
                throw new _MiscTemplateException((Expression)this, new Object[]{"Cannot convert ", TemplateDateModel.TYPE_NAMES.get(dtype), " to ", TemplateDateModel.TYPE_NAMES.get(this.dateType)});
            }
            String s2 = this.target.evalAndCoerceToString(env);
            return new DateParser(s2, env);
        }

        private class DateParser
        implements TemplateDateModel,
        TemplateMethodModel,
        TemplateHashModel {
            private final String text;
            private final Environment env;
            private final TemplateDateFormat defaultFormat;
            private Date cachedValue;

            DateParser(String text, Environment env) throws TemplateModelException {
                this.text = text;
                this.env = env;
                this.defaultFormat = env.getTemplateDateFormat(dateBI.this.dateType, class$java$util$Date == null ? (class$java$util$Date = BuiltInsForMultipleTypes.class$("java.util.Date")) : class$java$util$Date, dateBI.this.target);
            }

            public Object exec(List args) throws TemplateModelException {
                dateBI.this.checkMethodArgCount(args, 1);
                return this.get((String)args.get(0));
            }

            public TemplateModel get(String pattern) throws TemplateModelException {
                return new SimpleDate(this.parse(this.env.getTemplateDateFormat(dateBI.this.dateType, class$java$util$Date == null ? (class$java$util$Date = BuiltInsForMultipleTypes.class$("java.util.Date")) : class$java$util$Date, pattern, dateBI.this.target)), dateBI.this.dateType);
            }

            public Date getAsDate() throws TemplateModelException {
                if (this.cachedValue == null) {
                    this.cachedValue = this.parse(this.defaultFormat);
                }
                return this.cachedValue;
            }

            public int getDateType() {
                return dateBI.this.dateType;
            }

            public boolean isEmpty() {
                return false;
            }

            private Date parse(TemplateDateFormat df) throws TemplateModelException {
                try {
                    return df.parse(this.text);
                }
                catch (ParseException e) {
                    throw new _TemplateModelException((Throwable)e, new Object[]{"The string doesn't match the expected date/time/date-time format. The string to parse was: ", new _DelayedJQuote(this.text), ". ", "The expected format was: ", new _DelayedJQuote(df.getDescription()), ".", e.getMessage() != null ? "\nThe nested reason given follows:\n" : "", e.getMessage() != null ? e.getMessage() : ""});
                }
            }
        }
    }

    static class cBI
    extends AbstractCBI
    implements ICIChainMember {
        private final BIBeforeICE2d3d21 prevICIObj = new BIBeforeICE2d3d21();

        cBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel model = this.target.eval(env);
            if (model instanceof TemplateNumberModel) {
                return this.formatNumber(env, model);
            }
            if (model instanceof TemplateBooleanModel) {
                return new SimpleScalar(((TemplateBooleanModel)model).getAsBoolean() ? "true" : "false");
            }
            throw new UnexpectedTypeException(this.target, model, "number or boolean", new Class[]{class$freemarker$template$TemplateNumberModel == null ? (class$freemarker$template$TemplateNumberModel = BuiltInsForMultipleTypes.class$("znaishaded.freemarker.template.TemplateNumberModel")) : class$freemarker$template$TemplateNumberModel, class$freemarker$template$TemplateBooleanModel == null ? (class$freemarker$template$TemplateBooleanModel = BuiltInsForMultipleTypes.class$("znaishaded.freemarker.template.TemplateBooleanModel")) : class$freemarker$template$TemplateBooleanModel}, env);
        }

        protected TemplateModel formatNumber(Environment env, TemplateModel model) throws TemplateModelException {
            Number num = EvalUtil.modelToNumber((TemplateNumberModel)model, this.target);
            if (num instanceof Integer || num instanceof Long) {
                return new SimpleScalar(num.toString());
            }
            if (num instanceof Double) {
                double n = num.doubleValue();
                if (n == Double.POSITIVE_INFINITY) {
                    return new SimpleScalar("INF");
                }
                if (n == Double.NEGATIVE_INFINITY) {
                    return new SimpleScalar("-INF");
                }
                if (Double.isNaN(n)) {
                    return new SimpleScalar("NaN");
                }
            } else if (num instanceof Float) {
                float n = num.floatValue();
                if (n == Float.POSITIVE_INFINITY) {
                    return new SimpleScalar("INF");
                }
                if (n == Float.NEGATIVE_INFINITY) {
                    return new SimpleScalar("-INF");
                }
                if (Float.isNaN(n)) {
                    return new SimpleScalar("NaN");
                }
            }
            return new SimpleScalar(env.getCNumberFormat().format(num));
        }

        public int getMinimumICIVersion() {
            return _TemplateAPI.VERSION_INT_2_3_21;
        }

        public Object getPreviousICIChainMember() {
            return this.prevICIObj;
        }

        static class BIBeforeICE2d3d21
        extends AbstractCBI {
            BIBeforeICE2d3d21() {
            }

            protected TemplateModel formatNumber(Environment env, TemplateModel model) throws TemplateModelException {
                Number num = EvalUtil.modelToNumber((TemplateNumberModel)model, this.target);
                if (num instanceof Integer || num instanceof Long) {
                    return new SimpleScalar(num.toString());
                }
                return new SimpleScalar(env.getCNumberFormat().format(num));
            }
        }
    }
}

