/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.core;

import java.util.Arrays;
import znaishaded.freemarker.core.Environment;
import znaishaded.freemarker.core.Expression;
import znaishaded.freemarker.core.FMParserTokenManager;
import znaishaded.freemarker.core.ParameterRole;
import znaishaded.freemarker.core.ParseException;
import znaishaded.freemarker.core.TemplateElement;
import znaishaded.freemarker.core.Token;
import znaishaded.freemarker.core._CoreStringUtils;
import znaishaded.freemarker.template.Configuration;
import znaishaded.freemarker.template.TemplateBooleanModel;
import znaishaded.freemarker.template.TemplateException;
import znaishaded.freemarker.template.TemplateModel;
import znaishaded.freemarker.template.TemplateNumberModel;
import znaishaded.freemarker.template.TemplateScalarModel;
import znaishaded.freemarker.template._TemplateAPI;
import znaishaded.freemarker.template.utility.StringUtil;

final class PropertySetting
extends TemplateElement {
    private final String key;
    private final Expression value;
    static final String[] SETTING_NAMES = new String[]{"booleanFormat", "boolean_format", "classicCompatible", "classic_compatible", "dateFormat", "date_format", "datetimeFormat", "datetime_format", "locale", "numberFormat", "number_format", "outputEncoding", "output_encoding", "sqlDateAndTimeTimeZone", "sql_date_and_time_time_zone", "timeFormat", "timeZone", "time_format", "time_zone", "urlEscapingCharset", "url_escaping_charset"};

    PropertySetting(Token keyTk, FMParserTokenManager tokenManager, Expression value, Configuration cfg) throws ParseException {
        String key = keyTk.image;
        if (Arrays.binarySearch(SETTING_NAMES, key) < 0) {
            StringBuffer sb = new StringBuffer();
            if (_TemplateAPI.getConfigurationSettingNames(cfg, true).contains(key) || _TemplateAPI.getConfigurationSettingNames(cfg, false).contains(key)) {
                sb.append("The setting name is recognized, but changing this setting from inside a template isn't supported.");
            } else {
                sb.append("Unknown setting name: ");
                sb.append(StringUtil.jQuote(key)).append(".");
                sb.append(" The allowed setting names are: ");
                int namingConvention = tokenManager.namingConvention;
                int shownNamingConvention = namingConvention != 10 ? namingConvention : 11;
                boolean first = true;
                for (int i = 0; i < SETTING_NAMES.length; ++i) {
                    String correctName = SETTING_NAMES[i];
                    int correctNameNamingConvetion = _CoreStringUtils.getIdentifierNamingConvention(correctName);
                    if (!(shownNamingConvention == 12 ? correctNameNamingConvetion != 11 : correctNameNamingConvetion != 12)) continue;
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(SETTING_NAMES[i]);
                }
            }
            throw new ParseException(sb.toString(), null, keyTk);
        }
        this.key = key;
        this.value = value;
    }

    void accept(Environment env) throws TemplateException {
        TemplateModel mval = this.value.eval(env);
        String strval = mval instanceof TemplateScalarModel ? ((TemplateScalarModel)mval).getAsString() : (mval instanceof TemplateBooleanModel ? (((TemplateBooleanModel)mval).getAsBoolean() ? "true" : "false") : (mval instanceof TemplateNumberModel ? ((TemplateNumberModel)mval).getAsNumber().toString() : this.value.evalAndCoerceToString(env)));
        env.setSetting(this.key, strval);
    }

    protected String dump(boolean canonical) {
        StringBuffer sb = new StringBuffer();
        if (canonical) {
            sb.append('<');
        }
        sb.append(this.getNodeTypeSymbol());
        sb.append(' ');
        sb.append(_CoreStringUtils.toFTLTopLevelTragetIdentifier(this.key));
        sb.append('=');
        sb.append(this.value.getCanonicalForm());
        if (canonical) {
            sb.append("/>");
        }
        return sb.toString();
    }

    String getNodeTypeSymbol() {
        return "#setting";
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.key;
            }
            case 1: {
                return this.value;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.ITEM_KEY;
            }
            case 1: {
                return ParameterRole.ITEM_VALUE;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

