/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.core;

import java.io.IOException;
import znaishaded.freemarker.core.BreakInstruction;
import znaishaded.freemarker.core.Case;
import znaishaded.freemarker.core.Environment;
import znaishaded.freemarker.core.EvalUtil;
import znaishaded.freemarker.core.Expression;
import znaishaded.freemarker.core.ParameterRole;
import znaishaded.freemarker.core.TemplateElement;
import znaishaded.freemarker.template.TemplateException;

final class SwitchBlock
extends TemplateElement {
    private Case defaultCase;
    private final Expression searched;

    SwitchBlock(Expression searched) {
        this.searched = searched;
        this.setRegulatedChildBufferCapacity(4);
    }

    void addCase(Case cas) {
        if (cas.condition == null) {
            this.defaultCase = cas;
        }
        this.addRegulatedChild(cas);
    }

    void accept(Environment env) throws TemplateException, IOException {
        boolean processedCase = false;
        int ln = this.getRegulatedChildCount();
        try {
            for (int i = 0; i < ln; ++i) {
                Case cas = (Case)this.getRegulatedChild(i);
                boolean processCase = false;
                if (processedCase) {
                    processCase = true;
                } else if (cas.condition != null) {
                    processCase = EvalUtil.compare(this.searched, 1, "case==", cas.condition, cas.condition, env);
                }
                if (!processCase) continue;
                env.visitByHiddingParent(cas);
                processedCase = true;
            }
            if (!processedCase && this.defaultCase != null) {
                env.visitByHiddingParent(this.defaultCase);
            }
        }
        catch (BreakInstruction.Break br) {
            // empty catch block
        }
    }

    protected String dump(boolean canonical) {
        StringBuffer buf = new StringBuffer();
        if (canonical) {
            buf.append('<');
        }
        buf.append(this.getNodeTypeSymbol());
        buf.append(' ');
        buf.append(this.searched.getCanonicalForm());
        if (canonical) {
            buf.append('>');
            int ln = this.getRegulatedChildCount();
            for (int i = 0; i < ln; ++i) {
                Case cas = (Case)this.getRegulatedChild(i);
                buf.append(cas.getCanonicalForm());
            }
            buf.append("</").append(this.getNodeTypeSymbol()).append('>');
        }
        return buf.toString();
    }

    String getNodeTypeSymbol() {
        return "#switch";
    }

    int getParameterCount() {
        return 1;
    }

    Object getParameterValue(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.searched;
    }

    ParameterRole getParameterRole(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return ParameterRole.VALUE;
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

