/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core;

import java.util.function.Function;
import znaishaded.io.vertx.codegen.annotations.CacheReturn;
import znaishaded.io.vertx.codegen.annotations.Fluent;
import znaishaded.io.vertx.codegen.annotations.GenIgnore;
import znaishaded.io.vertx.codegen.annotations.VertxGen;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.ServiceHelper;
import znaishaded.io.vertx.core.spi.FutureFactory;

@VertxGen
public interface Future<T>
extends AsyncResult<T>,
Handler<AsyncResult<T>> {
    public static final FutureFactory factory = ServiceHelper.loadFactory(FutureFactory.class);

    public static <T> Future<T> future(Handler<Future<T>> handler) {
        Future<T> fut = Future.future();
        handler.handle(fut);
        return fut;
    }

    public static <T> Future<T> future() {
        return factory.future();
    }

    public static <T> Future<T> succeededFuture() {
        return factory.succeededFuture();
    }

    public static <T> Future<T> succeededFuture(T result) {
        return factory.succeededFuture(result);
    }

    public static <T> Future<T> failedFuture(Throwable t) {
        return factory.failedFuture(t);
    }

    public static <T> Future<T> failedFuture(String failureMessage) {
        return factory.failureFuture(failureMessage);
    }

    public boolean isComplete();

    @Fluent
    public Future<T> setHandler(Handler<AsyncResult<T>> var1);

    public void complete(T var1);

    public void complete();

    public void fail(Throwable var1);

    public void fail(String var1);

    public boolean tryComplete(T var1);

    public boolean tryComplete();

    public boolean tryFail(Throwable var1);

    public boolean tryFail(String var1);

    @Override
    public T result();

    @Override
    public Throwable cause();

    @Override
    public boolean succeeded();

    @Override
    public boolean failed();

    default public <U> Future<U> compose(Handler<T> handler, Future<U> next) {
        this.setHandler(ar -> {
            if (ar.succeeded()) {
                try {
                    handler.handle(ar.result());
                }
                catch (Throwable err) {
                    if (next.isComplete()) {
                        throw err;
                    }
                    next.fail(err);
                }
            } else {
                next.fail(ar.cause());
            }
        });
        return next;
    }

    default public <U> Future<U> compose(Function<T, Future<U>> mapper) {
        if (mapper == null) {
            throw new NullPointerException();
        }
        Future ret = Future.future();
        this.setHandler(ar -> {
            if (ar.succeeded()) {
                Future apply;
                try {
                    apply = (Future)mapper.apply(ar.result());
                }
                catch (Throwable e) {
                    ret.fail(e);
                    return;
                }
                apply.setHandler(ret);
            } else {
                ret.fail(ar.cause());
            }
        });
        return ret;
    }

    @Override
    default public <U> Future<U> map(Function<T, U> mapper) {
        if (mapper == null) {
            throw new NullPointerException();
        }
        Future ret = Future.future();
        this.setHandler(ar -> {
            if (ar.succeeded()) {
                Object mapped;
                try {
                    mapped = mapper.apply(ar.result());
                }
                catch (Throwable e) {
                    ret.fail(e);
                    return;
                }
                ret.complete(mapped);
            } else {
                ret.fail(ar.cause());
            }
        });
        return ret;
    }

    @Override
    default public <V> Future<V> map(V value) {
        Future ret = Future.future();
        this.setHandler(ar -> {
            if (ar.succeeded()) {
                ret.complete(value);
            } else {
                ret.fail(ar.cause());
            }
        });
        return ret;
    }

    @Override
    default public <V> Future<V> mapEmpty() {
        return (Future)AsyncResult.super.mapEmpty();
    }

    @Override
    @GenIgnore
    public void handle(AsyncResult<T> var1);

    @CacheReturn
    default public Handler<AsyncResult<T>> completer() {
        return this;
    }

    default public Future<T> recover(Function<Throwable, Future<T>> mapper) {
        if (mapper == null) {
            throw new NullPointerException();
        }
        Future<T> ret = Future.future();
        this.setHandler(ar -> {
            if (ar.succeeded()) {
                ret.complete(this.result());
            } else {
                Future mapped;
                try {
                    mapped = (Future)mapper.apply(ar.cause());
                }
                catch (Throwable e) {
                    ret.fail(e);
                    return;
                }
                mapped.setHandler(ret);
            }
        });
        return ret;
    }

    @Override
    default public Future<T> otherwise(Function<Throwable, T> mapper) {
        if (mapper == null) {
            throw new NullPointerException();
        }
        Future<T> ret = Future.future();
        this.setHandler(ar -> {
            if (ar.succeeded()) {
                ret.complete(this.result());
            } else {
                Object value;
                try {
                    value = mapper.apply(ar.cause());
                }
                catch (Throwable e) {
                    ret.fail(e);
                    return;
                }
                ret.complete(value);
            }
        });
        return ret;
    }

    @Override
    default public Future<T> otherwise(T value) {
        Future<T> ret = Future.future();
        this.setHandler(ar -> {
            if (ar.succeeded()) {
                ret.complete(this.result());
            } else {
                ret.complete(value);
            }
        });
        return ret;
    }

    @Override
    default public Future<T> otherwiseEmpty() {
        return (Future)AsyncResult.super.otherwiseEmpty();
    }
}

