/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.cli.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import znaishaded.io.vertx.core.cli.AmbiguousOptionException;
import znaishaded.io.vertx.core.cli.Argument;
import znaishaded.io.vertx.core.cli.CLI;
import znaishaded.io.vertx.core.cli.CLIException;
import znaishaded.io.vertx.core.cli.CommandLine;
import znaishaded.io.vertx.core.cli.InvalidValueException;
import znaishaded.io.vertx.core.cli.MissingOptionException;
import znaishaded.io.vertx.core.cli.MissingValueException;
import znaishaded.io.vertx.core.cli.Option;
import znaishaded.io.vertx.core.cli.impl.DefaultCommandLine;

public class DefaultParser {
    protected String token;
    protected Option current;
    protected List<Option> expectedOpts;
    private DefaultCommandLine commandLine;
    private boolean skipParsing;
    private CLI cli;

    static String stripLeadingHyphens(String str) {
        if (str == null) {
            return null;
        }
        if (str.startsWith("--")) {
            return str.substring(2, str.length());
        }
        if (str.startsWith("-")) {
            return str.substring(1, str.length());
        }
        return str;
    }

    static String stripLeadingAndTrailingQuotes(String str) {
        int length = str.length();
        if (length > 1 && str.startsWith("\"") && str.endsWith("\"") && str.substring(1, length - 1).indexOf(34) == -1) {
            str = str.substring(1, length - 1);
        }
        return str;
    }

    public CommandLine parse(CLI cli, List<String> cla) throws CLIException {
        return this.parse(cli, cla, true);
    }

    public CommandLine parse(CLI cli, List<String> cla, boolean validate) throws CLIException {
        this.commandLine = (DefaultCommandLine)CommandLine.create(cli);
        this.current = null;
        this.skipParsing = false;
        this.cli = cli;
        int current = 0;
        for (Argument argument : cli.getArguments()) {
            if (argument.getIndex() == -1) {
                argument.setIndex(current);
                ++current;
                continue;
            }
            current = argument.getIndex() + 1;
        }
        cli.getArguments().sort((o1, o2) -> {
            if (o1.getIndex() == o2.getIndex()) {
                return 1;
            }
            return Integer.valueOf(o1.getIndex()).compareTo(o2.getIndex());
        });
        cli.getOptions().stream().forEach(Option::ensureValidity);
        cli.getArguments().stream().forEach(Argument::ensureValidity);
        this.expectedOpts = this.getRequiredOptions();
        if (cla != null) {
            cla.forEach(this::visit);
        }
        try {
            this.checkRequiredValues();
            this.checkRequiredOptions();
            this.validate();
            this.commandLine.setValidity(true);
        }
        catch (CLIException e) {
            if (validate && !this.commandLine.isAskingForHelp()) {
                throw e;
            }
            this.commandLine.setValidity(false);
        }
        return this.commandLine;
    }

    protected void validate() throws CLIException {
        boolean multiValue = false;
        ArrayList<Integer> usedIndexes = new ArrayList<Integer>();
        for (Argument argument : this.cli.getArguments()) {
            if (usedIndexes.contains(argument.getIndex())) {
                throw new CLIException("Only one argument can use the index " + argument.getIndex());
            }
            usedIndexes.add(argument.getIndex());
            if (multiValue) {
                throw new CLIException("Only the last argument can be multi-valued");
            }
            multiValue = argument.isMultiValued();
        }
        Iterator<Argument> iterator = this.cli.getArguments().iterator();
        Argument current = null;
        if (iterator.hasNext()) {
            current = iterator.next();
        }
        for (String v : this.commandLine.allArguments()) {
            if (current == null) continue;
            this.commandLine.setRawValue(current, v);
            if (current.isMultiValued()) continue;
            if (iterator.hasNext()) {
                current = iterator.next();
                continue;
            }
            current = null;
        }
        for (Argument arg : this.cli.getArguments()) {
            if (!arg.isRequired() || this.commandLine.isArgumentAssigned(arg)) continue;
            throw new MissingValueException(arg);
        }
    }

    private List<Option> getRequiredOptions() {
        return this.cli.getOptions().stream().filter(Option::isRequired).collect(Collectors.toList());
    }

    private void checkRequiredOptions() throws MissingOptionException {
        if (!this.expectedOpts.isEmpty()) {
            throw new MissingOptionException(this.expectedOpts);
        }
    }

    private void checkRequiredValues() throws MissingValueException {
        if (this.current != null && this.current.acceptValue() && !this.commandLine.isOptionAssigned(this.current) && !this.current.isFlag()) {
            throw new MissingValueException(this.current);
        }
    }

    private void visit(String token) throws CLIException {
        this.token = token;
        if (this.skipParsing) {
            this.commandLine.addArgumentValue(token);
        } else if (token.equals("--")) {
            this.skipParsing = true;
        } else if (this.current != null && this.current.acceptValue() && this.isValue(token)) {
            this.commandLine.addRawValue(this.current, DefaultParser.stripLeadingAndTrailingQuotes(token));
        } else if (token.startsWith("--")) {
            this.handleLongOption(token);
        } else if (token.startsWith("-") && !"-".equals(token)) {
            this.handleShortAndLongOption(token);
        } else {
            this.handleArgument(token);
        }
        if (this.current != null && !this.commandLine.acceptMoreValues(this.current)) {
            this.current = null;
        }
    }

    private boolean isValue(String token) {
        return !this.isOption(token) || this.isNegativeNumber(token);
    }

    private boolean isNegativeNumber(String token) {
        try {
            Double.parseDouble(token);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isOption(String token) {
        return this.isLongOption(token) || this.isShortOption(token);
    }

    private boolean isShortOption(String token) {
        return token.startsWith("-") && token.length() >= 2 && this.hasOptionWithShortName(token.substring(1, 2));
    }

    private boolean isLongOption(String token) {
        String t;
        if (!token.startsWith("-") || token.length() == 1) {
            return false;
        }
        int pos = token.indexOf("=");
        String string = t = pos == -1 ? token : token.substring(0, pos);
        if (!this.getMatchingOptions(t).isEmpty()) {
            return true;
        }
        return this.getLongPrefix(token) != null && !token.startsWith("--");
    }

    private void handleArgument(String token) {
        this.commandLine.addArgumentValue(token);
    }

    private void handleLongOption(String token) throws CLIException {
        if (token.indexOf(61) == -1) {
            this.handleLongOptionWithoutEqual(token);
        } else {
            this.handleLongOptionWithEqual(token);
        }
    }

    private void handleLongOptionWithoutEqual(String token) throws CLIException {
        List<Option> matchingOpts = this.getMatchingOptions(token);
        if (matchingOpts.isEmpty()) {
            this.handleArgument(token);
        } else {
            if (matchingOpts.size() > 1) {
                throw new AmbiguousOptionException(token, matchingOpts);
            }
            Option option = matchingOpts.get(0);
            this.handleOption(option);
        }
    }

    private void handleLongOptionWithEqual(String token) throws CLIException {
        int pos = token.indexOf(61);
        String value = token.substring(pos + 1);
        String opt = token.substring(0, pos);
        List<Option> matchingOpts = this.getMatchingOptions(opt);
        if (matchingOpts.isEmpty()) {
            this.handleArgument(token);
        } else {
            if (matchingOpts.size() > 1) {
                throw new AmbiguousOptionException(opt, matchingOpts);
            }
            Option option = matchingOpts.get(0);
            if (this.commandLine.acceptMoreValues(option)) {
                this.handleOption(option);
                this.commandLine.addRawValue(option, value);
                this.current = null;
            } else {
                throw new InvalidValueException(option, value);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleShortAndLongOption(String token) throws CLIException {
        String t = DefaultParser.stripLeadingHyphens(token);
        int pos = t.indexOf(61);
        if (t.length() == 1) {
            if (this.hasOptionWithShortName(t)) {
                this.handleOption(this.getOption(t));
                return;
            } else {
                this.handleArgument(token);
            }
            return;
        } else if (pos == -1) {
            if (this.hasOptionWithShortName(t)) {
                this.handleOption(this.getOption(t));
                return;
            } else if (!this.getMatchingOptions(t).isEmpty()) {
                this.handleLongOptionWithoutEqual(token);
                return;
            } else {
                String opt = this.getLongPrefix(t);
                if (opt != null) {
                    if (!this.commandLine.acceptMoreValues(this.getOption(opt))) throw new InvalidValueException(this.getOption(opt), t.substring(opt.length()));
                    this.handleOption(this.getOption(opt));
                    this.commandLine.addRawValue(this.getOption(opt), t.substring(opt.length()));
                    this.current = null;
                    return;
                } else if (this.isAValidShortOption(t)) {
                    String strip = t.substring(0, 1);
                    Option option = this.getOption(strip);
                    this.handleOption(option);
                    this.commandLine.addRawValue(this.current, t.substring(1));
                    this.current = null;
                    return;
                } else {
                    this.handleConcatenatedOptions(token);
                }
            }
            return;
        } else {
            String opt = t.substring(0, pos);
            String value = t.substring(pos + 1);
            if (opt.length() == 1) {
                Option option = this.getOption(opt);
                if (option != null) {
                    if (!this.commandLine.acceptMoreValues(option)) throw new InvalidValueException(option, value);
                    this.handleOption(option);
                    this.commandLine.addRawValue(option, value);
                    this.current = null;
                    return;
                } else {
                    this.handleArgument(token);
                }
                return;
            } else if (this.isAValidShortOption(opt) && !this.hasOptionWithLongName(opt)) {
                this.handleOption(this.getOption(opt.substring(0, 1)));
                this.commandLine.addRawValue(this.current, opt.substring(1) + "=" + value);
                this.current = null;
                return;
            } else {
                this.handleLongOptionWithEqual(token);
            }
        }
    }

    private String getLongPrefix(String token) {
        String t = DefaultParser.stripLeadingHyphens(token);
        String opt = null;
        for (int i = t.length() - 2; i > 1; --i) {
            String prefix = t.substring(0, i);
            if (!this.hasOptionWithLongName(prefix)) continue;
            opt = prefix;
            break;
        }
        return opt;
    }

    private boolean hasOptionWithLongName(String name) {
        for (Option option : this.cli.getOptions()) {
            if (!name.equalsIgnoreCase(option.getLongName())) continue;
            return true;
        }
        return false;
    }

    private boolean hasOptionWithShortName(String name) {
        for (Option option : this.cli.getOptions()) {
            if (!name.equalsIgnoreCase(option.getShortName())) continue;
            return true;
        }
        return false;
    }

    private void handleOption(Option option) throws CLIException {
        this.checkRequiredValues();
        this.updateRequiredOptions(option);
        this.commandLine.setSeenInCommandLine(option);
        this.current = this.commandLine.acceptMoreValues(option) ? option : null;
    }

    private void updateRequiredOptions(Option option) {
        if (option.isRequired()) {
            this.expectedOpts.remove(option);
        }
    }

    public Option getOption(String opt) {
        opt = DefaultParser.stripLeadingHyphens(opt);
        for (Option option : this.cli.getOptions()) {
            if (!opt.equalsIgnoreCase(option.getShortName()) && !opt.equalsIgnoreCase(option.getLongName())) continue;
            return option;
        }
        return null;
    }

    private boolean isAValidShortOption(String token) {
        String opt = token.substring(0, 1);
        Option option = this.getOption(opt);
        return option != null && this.commandLine.acceptMoreValues(option);
    }

    public List<Option> getMatchingOptions(String opt) {
        opt = DefaultParser.stripLeadingHyphens(opt);
        ArrayList<Option> matching = new ArrayList<Option>();
        List<Option> options = this.cli.getOptions();
        for (Option option : options) {
            if (!opt.equalsIgnoreCase(option.getLongName())) continue;
            return Collections.singletonList(option);
        }
        for (Option option : options) {
            if (option.getLongName() == null || !option.getLongName().startsWith(opt)) continue;
            matching.add(option);
        }
        return matching;
    }

    protected void handleConcatenatedOptions(String token) throws CLIException {
        for (int i = 1; i < token.length(); ++i) {
            String ch = String.valueOf(token.charAt(i));
            if (this.hasOptionWithShortName(ch)) {
                this.handleOption(this.getOption(ch));
                if (this.current == null || token.length() == i + 1) continue;
                this.commandLine.addRawValue(this.current, token.substring(i + 1));
                break;
            }
            this.handleArgument(token);
            break;
        }
    }
}

