/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.dns.impl;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import znaishaded.io.netty.channel.ChannelHandlerContext;
import znaishaded.io.netty.channel.ChannelOption;
import znaishaded.io.netty.channel.EventLoop;
import znaishaded.io.netty.channel.SimpleChannelInboundHandler;
import znaishaded.io.netty.channel.socket.DatagramChannel;
import znaishaded.io.netty.channel.socket.InternetProtocolFamily;
import znaishaded.io.netty.handler.codec.dns.DatagramDnsQuery;
import znaishaded.io.netty.handler.codec.dns.DatagramDnsQueryEncoder;
import znaishaded.io.netty.handler.codec.dns.DatagramDnsResponseDecoder;
import znaishaded.io.netty.handler.codec.dns.DefaultDnsQuestion;
import znaishaded.io.netty.handler.codec.dns.DnsRecordType;
import znaishaded.io.netty.handler.codec.dns.DnsResponse;
import znaishaded.io.netty.handler.codec.dns.DnsSection;
import znaishaded.io.netty.util.collection.IntObjectHashMap;
import znaishaded.io.netty.util.collection.IntObjectMap;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.VertxException;
import znaishaded.io.vertx.core.dns.DnsClient;
import znaishaded.io.vertx.core.dns.DnsException;
import znaishaded.io.vertx.core.dns.DnsResponseCode;
import znaishaded.io.vertx.core.dns.MxRecord;
import znaishaded.io.vertx.core.dns.SrvRecord;
import znaishaded.io.vertx.core.dns.impl.MxRecordImpl;
import znaishaded.io.vertx.core.dns.impl.SrvRecordImpl;
import znaishaded.io.vertx.core.dns.impl.decoder.RecordDecoder;
import znaishaded.io.vertx.core.impl.ContextImpl;
import znaishaded.io.vertx.core.impl.VertxInternal;
import znaishaded.io.vertx.core.net.impl.PartialPooledByteBufAllocator;
import znaishaded.io.vertx.core.net.impl.transport.Transport;

public final class DnsClientImpl
implements DnsClient {
    private static final char[] HEX_TABLE = "0123456789abcdef".toCharArray();
    private final Vertx vertx;
    private final IntObjectMap<Query> inProgressMap = new IntObjectHashMap<Query>();
    private final InetSocketAddress dnsServer;
    private final ContextImpl actualCtx;
    private final DatagramChannel channel;
    private final long timeoutMillis;

    public DnsClientImpl(VertxInternal vertx, int port2, String host, long timeoutMillis) {
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("DNS client timeout " + timeoutMillis + " must be > 0");
        }
        ContextImpl creatingContext = vertx.getContext();
        if (creatingContext != null && creatingContext.isMultiThreadedWorkerContext()) {
            throw new IllegalStateException("Cannot use DnsClient in a multi-threaded worker verticle");
        }
        this.dnsServer = new InetSocketAddress(host, port2);
        this.vertx = vertx;
        this.timeoutMillis = timeoutMillis;
        Transport transport = vertx.transport();
        this.actualCtx = vertx.getOrCreateContext();
        this.channel = transport.datagramChannel(InternetProtocolFamily.IPv4);
        this.channel.config().setOption(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, true);
        this.channel.config().setMaxMessagesPerRead(1);
        this.channel.config().setAllocator(PartialPooledByteBufAllocator.INSTANCE);
        this.actualCtx.nettyEventLoop().register(this.channel);
        this.channel.pipeline().addLast(new DatagramDnsQueryEncoder());
        this.channel.pipeline().addLast(new DatagramDnsResponseDecoder());
        this.channel.pipeline().addLast(new SimpleChannelInboundHandler<DnsResponse>(){

            @Override
            protected void channelRead0(ChannelHandlerContext ctx, DnsResponse msg) throws Exception {
                int id = msg.id();
                Query query = (Query)DnsClientImpl.this.inProgressMap.get(id);
                if (query != null) {
                    query.handle(msg);
                }
            }
        });
    }

    @Override
    public DnsClient lookup4(String name, Handler<AsyncResult<String>> handler) {
        this.lookupSingle(name, handler, DnsRecordType.A);
        return this;
    }

    @Override
    public DnsClient lookup6(String name, Handler<AsyncResult<String>> handler) {
        this.lookupSingle(name, handler, DnsRecordType.AAAA);
        return this;
    }

    @Override
    public DnsClient lookup(String name, Handler<AsyncResult<String>> handler) {
        this.lookupSingle(name, handler, DnsRecordType.A, DnsRecordType.AAAA);
        return this;
    }

    @Override
    public DnsClient resolveA(String name, Handler<AsyncResult<List<String>>> handler) {
        this.lookupList(name, handler, DnsRecordType.A);
        return this;
    }

    @Override
    public DnsClient resolveCNAME(String name, Handler<AsyncResult<List<String>>> handler) {
        this.lookupList(name, handler, DnsRecordType.CNAME);
        return this;
    }

    @Override
    public DnsClient resolveMX(String name, Handler<AsyncResult<List<MxRecord>>> handler) {
        this.lookupList(name, handler, DnsRecordType.MX);
        return this;
    }

    @Override
    public DnsClient resolveTXT(String name, final Handler<AsyncResult<List<String>>> handler) {
        this.lookupList(name, new Handler<AsyncResult<List<String>>>(){

            @Override
            public void handle(AsyncResult event) {
                if (event.failed()) {
                    handler.handle(event);
                } else {
                    ArrayList txts = new ArrayList();
                    List records = (List)event.result();
                    for (List txt : records) {
                        txts.addAll(txt);
                    }
                    handler.handle(Future.succeededFuture(txts));
                }
            }
        }, DnsRecordType.TXT);
        return this;
    }

    @Override
    public DnsClient resolvePTR(String name, Handler<AsyncResult<String>> handler) {
        this.lookupSingle(name, handler, DnsRecordType.PTR);
        return this;
    }

    @Override
    public DnsClient resolveAAAA(String name, Handler<AsyncResult<List<String>>> handler) {
        this.lookupList(name, handler, DnsRecordType.AAAA);
        return this;
    }

    @Override
    public DnsClient resolveNS(String name, Handler<AsyncResult<List<String>>> handler) {
        this.lookupList(name, handler, DnsRecordType.NS);
        return this;
    }

    @Override
    public DnsClient resolveSRV(String name, Handler<AsyncResult<List<SrvRecord>>> handler) {
        this.lookupList(name, handler, DnsRecordType.SRV);
        return this;
    }

    @Override
    public DnsClient reverseLookup(String address, Handler<AsyncResult<String>> handler) {
        try {
            InetAddress inetAddress = InetAddress.getByName(address);
            byte[] addr = inetAddress.getAddress();
            StringBuilder reverseName = new StringBuilder(64);
            if (inetAddress instanceof Inet4Address) {
                reverseName.append(addr[3] & 0xFF).append(".").append(addr[2] & 0xFF).append(".").append(addr[1] & 0xFF).append(".").append(addr[0] & 0xFF);
            } else {
                for (int i = 0; i < 16; ++i) {
                    reverseName.append(HEX_TABLE[addr[15 - i] & 0xF]);
                    reverseName.append(".");
                    reverseName.append(HEX_TABLE[addr[15 - i] >> 4 & 0xF]);
                    if (i == 15) continue;
                    reverseName.append(".");
                }
            }
            reverseName.append(".in-addr.arpa");
            return this.resolvePTR(reverseName.toString(), handler);
        }
        catch (UnknownHostException e) {
            this.actualCtx.runOnContext(v -> handler.handle(Future.failedFuture(e)));
            return this;
        }
    }

    private <T> void lookupSingle(String name, Handler<AsyncResult<T>> handler, DnsRecordType ... types) {
        this.lookupList(name, ar -> handler.handle(ar.map(result -> result.isEmpty() ? null : result.get(0))), types);
    }

    private <T> void lookupList(String name, Handler<AsyncResult<List<T>>> handler, DnsRecordType ... types) {
        Objects.requireNonNull(name, "no null name accepted");
        EventLoop el = this.actualCtx.nettyEventLoop();
        if (el.inEventLoop()) {
            new Query<T>(name, types, handler).run();
        } else {
            el.execute(() -> new Query(name, types, handler).run());
        }
    }

    public void inProgressQueries(Handler<Integer> handler) {
        this.actualCtx.runOnContext(v -> handler.handle(this.inProgressMap.size()));
    }

    private class Query<T> {
        final DatagramDnsQuery msg;
        final Future<List<T>> fut;
        final String name;
        final DnsRecordType[] types;
        long timerID;

        public Query(String name, DnsRecordType[] types, Handler<AsyncResult<List<T>>> handler) {
            this.msg = new DatagramDnsQuery(null, DnsClientImpl.this.dnsServer, ThreadLocalRandom.current().nextInt()).setRecursionDesired(true);
            for (DnsRecordType type : types) {
                this.msg.addRecord(DnsSection.QUESTION, new DefaultDnsQuestion(name, type, 1));
            }
            this.fut = Future.future().setHandler(handler);
            this.types = types;
            this.name = name;
        }

        void fail(Throwable cause) {
            DnsClientImpl.this.inProgressMap.remove(this.msg.id());
            if (this.timerID >= 0L) {
                DnsClientImpl.this.vertx.cancelTimer(this.timerID);
            }
            DnsClientImpl.this.actualCtx.executeFromIO(() -> this.fut.tryFail(cause));
        }

        void handle(DnsResponse msg) {
            DnsResponseCode code = DnsResponseCode.valueOf(msg.code().intValue());
            if (code == DnsResponseCode.NOERROR) {
                DnsClientImpl.this.inProgressMap.remove(msg.id());
                if (this.timerID >= 0L) {
                    DnsClientImpl.this.vertx.cancelTimer(this.timerID);
                }
                int count = msg.count(DnsSection.ANSWER);
                ArrayList records = new ArrayList(count);
                for (int idx = 0; idx < count; ++idx) {
                    Object a = msg.recordAt(DnsSection.ANSWER, idx);
                    Object record = RecordDecoder.decode(a);
                    if (!this.isRequestedType(a.type(), this.types)) continue;
                    records.add(record);
                }
                if (records.size() > 0 && (records.get(0) instanceof MxRecordImpl || records.get(0) instanceof SrvRecordImpl)) {
                    Collections.sort(records);
                }
                DnsClientImpl.this.actualCtx.executeFromIO(() -> this.fut.tryComplete(records));
            } else {
                this.fail(new DnsException(code));
            }
        }

        void run() {
            DnsClientImpl.this.inProgressMap.put(this.msg.id(), this);
            this.timerID = DnsClientImpl.this.vertx.setTimer(DnsClientImpl.this.timeoutMillis, id -> {
                this.timerID = -1L;
                this.fail(new VertxException("DNS query timeout for " + this.name));
            });
            DnsClientImpl.this.channel.writeAndFlush(this.msg).addListener(future -> {
                if (!future.isSuccess()) {
                    this.fail(future.cause());
                }
            });
        }

        private boolean isRequestedType(DnsRecordType dnsRecordType, DnsRecordType[] types) {
            for (DnsRecordType t : types) {
                if (!t.equals(dnsRecordType)) continue;
                return true;
            }
            return false;
        }
    }
}

