/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.eventbus.impl.clustered;

import java.util.List;
import java.util.Map;
import znaishaded.io.netty.util.CharsetUtil;
import znaishaded.io.vertx.core.MultiMap;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.eventbus.MessageCodec;
import znaishaded.io.vertx.core.eventbus.impl.CodecManager;
import znaishaded.io.vertx.core.eventbus.impl.EventBusImpl;
import znaishaded.io.vertx.core.eventbus.impl.MessageImpl;
import znaishaded.io.vertx.core.http.CaseInsensitiveHeaders;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.core.net.impl.ServerID;

public class ClusteredMessage<U, V>
extends MessageImpl<U, V> {
    private static final Logger log = LoggerFactory.getLogger(ClusteredMessage.class);
    private static final byte WIRE_PROTOCOL_VERSION = 1;
    private ServerID sender;
    private Buffer wireBuffer;
    private int bodyPos;
    private int headersPos;
    private boolean fromWire;

    public ClusteredMessage() {
    }

    public ClusteredMessage(ServerID sender, String address, String replyAddress, MultiMap headers, U sentBody, MessageCodec<U, V> messageCodec, boolean send, EventBusImpl bus) {
        super(address, replyAddress, headers, sentBody, messageCodec, send, bus);
        this.sender = sender;
    }

    protected ClusteredMessage(ClusteredMessage<U, V> other) {
        super(other);
        this.sender = other.sender;
        if (other.sentBody == null) {
            this.wireBuffer = other.wireBuffer;
            this.bodyPos = other.bodyPos;
            this.headersPos = other.headersPos;
        }
        this.fromWire = other.fromWire;
    }

    @Override
    public ClusteredMessage<U, V> copyBeforeReceive() {
        return new ClusteredMessage<U, V>(this);
    }

    @Override
    public MultiMap headers() {
        if (this.headers == null) {
            if (this.headersPos != 0) {
                this.decodeHeaders();
            }
            if (this.headers == null) {
                this.headers = new CaseInsensitiveHeaders();
            }
        }
        return this.headers;
    }

    @Override
    public V body() {
        if (this.receivedBody == null && this.bodyPos != 0) {
            this.decodeBody();
        }
        return (V)this.receivedBody;
    }

    @Override
    public String replyAddress() {
        return this.replyAddress;
    }

    public Buffer encodeToWire() {
        int length = 1024;
        Buffer buffer = Buffer.buffer(length);
        buffer.appendInt(0);
        buffer.appendByte((byte)1);
        byte systemCodecID = this.messageCodec.systemCodecID();
        buffer.appendByte(systemCodecID);
        if (systemCodecID == -1) {
            this.writeString(buffer, this.messageCodec.name());
        }
        buffer.appendByte(this.send ? (byte)0 : 1);
        this.writeString(buffer, this.address);
        if (this.replyAddress != null) {
            this.writeString(buffer, this.replyAddress);
        } else {
            buffer.appendInt(0);
        }
        buffer.appendInt(this.sender.port);
        this.writeString(buffer, this.sender.host);
        this.encodeHeaders(buffer);
        this.writeBody(buffer);
        buffer.setInt(0, buffer.length() - 4);
        return buffer;
    }

    public void readFromWire(Buffer buffer, CodecManager codecManager) {
        int pos = 0;
        byte protocolVersion = buffer.getByte(pos);
        if (protocolVersion > 1) {
            throw new IllegalStateException("Invalid wire protocol version " + protocolVersion + " should be <= " + 1);
        }
        byte systemCodecCode = buffer.getByte(++pos);
        ++pos;
        if (systemCodecCode == -1) {
            int length = buffer.getInt(pos);
            byte[] bytes = buffer.getBytes(pos += 4, pos + length);
            String codecName = new String(bytes, CharsetUtil.UTF_8);
            this.messageCodec = codecManager.getCodec(codecName);
            if (this.messageCodec == null) {
                throw new IllegalStateException("No message codec registered with name " + codecName);
            }
            pos += length;
        } else {
            this.messageCodec = codecManager.systemCodecs()[systemCodecCode];
        }
        byte bsend = buffer.getByte(pos);
        this.send = bsend == 0;
        int length = buffer.getInt(++pos);
        byte[] bytes = buffer.getBytes(pos += 4, pos + length);
        this.address = new String(bytes, CharsetUtil.UTF_8);
        pos += length;
        length = buffer.getInt(pos);
        pos += 4;
        if (length != 0) {
            bytes = buffer.getBytes(pos, pos + length);
            this.replyAddress = new String(bytes, CharsetUtil.UTF_8);
            pos += length;
        }
        int senderPort = buffer.getInt(pos);
        length = buffer.getInt(pos += 4);
        bytes = buffer.getBytes(pos += 4, pos + length);
        String senderHost = new String(bytes, CharsetUtil.UTF_8);
        this.headersPos = pos += length;
        int headersLength = buffer.getInt(pos);
        this.bodyPos = pos += headersLength;
        this.sender = new ServerID(senderPort, senderHost);
        this.wireBuffer = buffer;
        this.fromWire = true;
    }

    private void decodeBody() {
        this.receivedBody = this.messageCodec.decodeFromWire(this.bodyPos, this.wireBuffer);
        this.bodyPos = 0;
    }

    private void encodeHeaders(Buffer buffer) {
        if (this.headers != null && !this.headers.isEmpty()) {
            int headersLengthPos = buffer.length();
            buffer.appendInt(0);
            buffer.appendInt(this.headers.size());
            List<Map.Entry<String, String>> entries = this.headers.entries();
            for (Map.Entry<String, String> entry : entries) {
                this.writeString(buffer, entry.getKey());
                this.writeString(buffer, entry.getValue());
            }
            int headersEndPos = buffer.length();
            buffer.setInt(headersLengthPos, headersEndPos - headersLengthPos);
        } else {
            buffer.appendInt(4);
        }
    }

    private void decodeHeaders() {
        int length = this.wireBuffer.getInt(this.headersPos);
        if (length != 4) {
            this.headersPos += 4;
            int numHeaders = this.wireBuffer.getInt(this.headersPos);
            this.headersPos += 4;
            this.headers = new CaseInsensitiveHeaders();
            for (int i = 0; i < numHeaders; ++i) {
                int keyLength = this.wireBuffer.getInt(this.headersPos);
                this.headersPos += 4;
                byte[] bytes = this.wireBuffer.getBytes(this.headersPos, this.headersPos + keyLength);
                String key = new String(bytes, CharsetUtil.UTF_8);
                this.headersPos += keyLength;
                int valLength = this.wireBuffer.getInt(this.headersPos);
                this.headersPos += 4;
                bytes = this.wireBuffer.getBytes(this.headersPos, this.headersPos + valLength);
                String val = new String(bytes, CharsetUtil.UTF_8);
                this.headersPos += valLength;
                this.headers.add(key, val);
            }
        }
        this.headersPos = 0;
    }

    private void writeBody(Buffer buff) {
        this.messageCodec.encodeToWire(buff, this.sentBody);
    }

    private void writeString(Buffer buff, String str) {
        byte[] strBytes = str.getBytes(CharsetUtil.UTF_8);
        buff.appendInt(strBytes.length);
        buff.appendBytes(strBytes);
    }

    ServerID getSender() {
        return this.sender;
    }

    public boolean isFromWire() {
        return this.fromWire;
    }

    @Override
    protected boolean isLocal() {
        return !this.isFromWire();
    }
}

