/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http;

import znaishaded.io.vertx.codegen.annotations.DataObject;
import znaishaded.io.vertx.core.json.JsonObject;

@DataObject
public class RequestOptions {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 80;
    public static final boolean DEFAULT_SSL = false;
    public static final String DEFAULT_URI = "";
    private String host;
    private int port;
    private boolean ssl;
    private String uri;

    public RequestOptions() {
        this.host = DEFAULT_HOST;
        this.port = 80;
        this.ssl = false;
        this.uri = DEFAULT_URI;
    }

    public RequestOptions(RequestOptions other) {
        this.setHost(other.host);
        this.setPort(other.port);
        this.setSsl(other.ssl);
        this.setURI(other.uri);
    }

    public RequestOptions(JsonObject json) {
        this.setHost(json.getString("host", DEFAULT_HOST));
        this.setPort(json.getInteger("port", 80));
        this.setSsl(json.getBoolean("ssl", false));
        this.setURI(json.getString("uri", DEFAULT_URI));
    }

    public String getHost() {
        return this.host;
    }

    public RequestOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public RequestOptions setPort(int port2) {
        this.port = port2;
        return this;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public RequestOptions setSsl(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public String getURI() {
        return this.uri;
    }

    public RequestOptions setURI(String uri) {
        this.uri = uri;
        return this;
    }
}

