/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl;

import java.io.RandomAccessFile;
import java.net.SocketAddress;
import znaishaded.io.netty.buffer.ByteBuf;
import znaishaded.io.netty.channel.AbstractChannel;
import znaishaded.io.netty.channel.Channel;
import znaishaded.io.netty.channel.ChannelConfig;
import znaishaded.io.netty.channel.ChannelFuture;
import znaishaded.io.netty.channel.ChannelFutureListener;
import znaishaded.io.netty.channel.ChannelHandlerContext;
import znaishaded.io.netty.channel.ChannelId;
import znaishaded.io.netty.channel.ChannelInboundHandlerAdapter;
import znaishaded.io.netty.channel.ChannelInitializer;
import znaishaded.io.netty.channel.ChannelMetadata;
import znaishaded.io.netty.channel.ChannelOutboundBuffer;
import znaishaded.io.netty.channel.ChannelPipeline;
import znaishaded.io.netty.channel.ChannelPromise;
import znaishaded.io.netty.channel.DefaultChannelConfig;
import znaishaded.io.netty.channel.EventLoop;
import znaishaded.io.netty.handler.stream.ChunkedFile;
import znaishaded.io.netty.handler.stream.ChunkedWriteHandler;
import znaishaded.io.netty.util.concurrent.GenericFutureListener;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.http.impl.VertxHttp2Stream;

class FileStreamChannel
extends AbstractChannel {
    private static final SocketAddress LOCAL_ADDRESS = new StreamSocketAddress();
    private static final SocketAddress REMOTE_ADDRESS = new StreamSocketAddress();
    private static final ChannelMetadata METADATA = new ChannelMetadata(true);
    private final ChannelConfig config = new DefaultChannelConfig(this);
    private boolean active;
    private boolean closed;
    private long bytesWritten;
    private final VertxHttp2Stream stream;
    final Handler<Void> drainHandler = v -> this.flush();

    FileStreamChannel(final Future<Long> result, VertxHttp2Stream stream, final long offset, final long length) {
        super(null, Id.INSTANCE);
        this.pipeline().addLast(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChunkedWriteHandler());
                pipeline.addLast(new ChannelInboundHandlerAdapter(){

                    @Override
                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt instanceof RandomAccessFile) {
                            ChannelFuture fut = ctx.writeAndFlush(new ChunkedFile((RandomAccessFile)evt, offset, length, 8192));
                            fut.addListener((GenericFutureListener<? extends znaishaded.io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<znaishaded.io.netty.util.concurrent.Future>)f -> {
                                if (f.isSuccess()) {
                                    result.tryComplete(FileStreamChannel.this.bytesWritten);
                                } else {
                                    result.tryFail(f.cause());
                                }
                                fut.addListener(ChannelFutureListener.CLOSE);
                            }));
                        }
                    }

                    @Override
                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        result.tryFail(cause);
                    }
                });
            }
        });
        this.stream = stream;
    }

    @Override
    protected void doRegister() throws Exception {
        this.active = true;
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new DefaultUnsafe();
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return true;
    }

    @Override
    protected SocketAddress localAddress0() {
        return LOCAL_ADDRESS;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return REMOTE_ADDRESS;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    @Override
    protected void doClose() throws Exception {
        this.active = false;
        this.closed = true;
    }

    @Override
    protected void doBeginRead() throws Exception {
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        ByteBuf chunk;
        while (!this.stream.isNotWritable() && (chunk = (ByteBuf)in.current()) != null) {
            this.bytesWritten += (long)chunk.readableBytes();
            this.stream.writeData(chunk.retain(), false);
            this.stream.handlerContext.flush();
            in.remove();
        }
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    static class Id
    implements ChannelId {
        static final ChannelId INSTANCE = new Id();

        private Id() {
        }

        @Override
        public String asShortText() {
            return this.toString();
        }

        @Override
        public String asLongText() {
            return this.toString();
        }

        @Override
        public int compareTo(ChannelId o) {
            if (o instanceof Id) {
                return 0;
            }
            return this.asLongText().compareTo(o.asLongText());
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof Id;
        }

        public String toString() {
            return "stream";
        }
    }

    private class DefaultUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private DefaultUnsafe() {
            super(FileStreamChannel.this);
        }

        @Override
        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            this.safeSetSuccess(promise);
        }
    }

    private static class StreamSocketAddress
    extends SocketAddress {
        private StreamSocketAddress() {
        }

        public String toString() {
            return "stream";
        }
    }
}

