/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl;

import java.net.URISyntaxException;
import java.nio.channels.ClosedChannelException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import znaishaded.io.netty.handler.codec.http.DefaultHttpContent;
import znaishaded.io.netty.handler.codec.http.DefaultHttpRequest;
import znaishaded.io.netty.handler.codec.http.HttpHeaderNames;
import znaishaded.io.netty.handler.codec.http.HttpHeaderValues;
import znaishaded.io.netty.handler.codec.http.LastHttpContent;
import znaishaded.io.netty.handler.codec.http.multipart.Attribute;
import znaishaded.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import znaishaded.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import znaishaded.io.netty.handler.codec.http2.Http2Headers;
import znaishaded.io.netty.handler.codec.http2.Http2Stream;
import znaishaded.io.vertx.codegen.annotations.Nullable;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.MultiMap;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.http.CaseInsensitiveHeaders;
import znaishaded.io.vertx.core.http.HttpConnection;
import znaishaded.io.vertx.core.http.HttpFrame;
import znaishaded.io.vertx.core.http.HttpMethod;
import znaishaded.io.vertx.core.http.HttpServerFileUpload;
import znaishaded.io.vertx.core.http.HttpServerRequest;
import znaishaded.io.vertx.core.http.HttpVersion;
import znaishaded.io.vertx.core.http.ServerWebSocket;
import znaishaded.io.vertx.core.http.StreamResetException;
import znaishaded.io.vertx.core.http.impl.Http2HeadersAdaptor;
import znaishaded.io.vertx.core.http.impl.Http2ServerConnection;
import znaishaded.io.vertx.core.http.impl.Http2ServerResponseImpl;
import znaishaded.io.vertx.core.http.impl.HttpFrameImpl;
import znaishaded.io.vertx.core.http.impl.HttpServerRequestImpl;
import znaishaded.io.vertx.core.http.impl.HttpUtils;
import znaishaded.io.vertx.core.http.impl.NettyFileUploadDataFactory;
import znaishaded.io.vertx.core.http.impl.VertxHttp2Stream;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.core.net.NetSocket;
import znaishaded.io.vertx.core.net.SocketAddress;
import znaishaded.io.vertx.core.spi.metrics.HttpServerMetrics;
import znaishaded.io.vertx.core.spi.metrics.Metrics;

public class Http2ServerRequestImpl
extends VertxHttp2Stream<Http2ServerConnection>
implements HttpServerRequest {
    private static final Logger log = LoggerFactory.getLogger(HttpServerRequestImpl.class);
    private final String serverOrigin;
    private final Http2ServerResponseImpl response;
    private final Http2Headers headers;
    private MultiMap headersMap;
    private MultiMap params;
    private HttpMethod method;
    private String rawMethod;
    private String absoluteURI;
    private String uri;
    private String path;
    private String query;
    private MultiMap attributes;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private boolean ended;
    private long bytesRead;
    private Handler<HttpServerFileUpload> uploadHandler;
    private HttpPostRequestDecoder postRequestDecoder;
    private Handler<Throwable> exceptionHandler;
    private Handler<HttpFrame> customFrameHandler;
    private NetSocket netSocket;

    public Http2ServerRequestImpl(Http2ServerConnection conn, Http2Stream stream, HttpServerMetrics metrics, String serverOrigin, Http2Headers headers, String contentEncoding, boolean writable) {
        super(conn, stream, writable);
        this.serverOrigin = serverOrigin;
        this.headers = headers;
        String host = this.host();
        if (host == null) {
            int idx = serverOrigin.indexOf("://");
            host = serverOrigin.substring(idx + 3);
        }
        this.response = new Http2ServerResponseImpl(conn, this, this.method(), false, contentEncoding, host);
        if (Metrics.METRICS_ENABLED && metrics != null) {
            this.response.metric(metrics.requestBegin(conn.metric(), this));
        }
    }

    @Override
    void handleInterestedOpsChanged() {
        this.response.writabilityChanged();
    }

    @Override
    void handleException(Throwable cause) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(cause);
            this.response.handleError(cause);
        }
    }

    @Override
    void handleClose() {
        if (!this.ended) {
            this.ended = true;
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(new ClosedChannelException());
            }
        }
        this.response.handleClose();
    }

    @Override
    void handleCustomFrame(int type, int flags, Buffer buff) {
        if (this.customFrameHandler != null) {
            this.customFrameHandler.handle(new HttpFrameImpl(type, flags, buff));
        }
    }

    @Override
    void handleData(Buffer data) {
        this.bytesRead += (long)data.length();
        if (this.postRequestDecoder != null) {
            try {
                this.postRequestDecoder.offer(new DefaultHttpContent(data.getByteBuf()));
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        if (this.dataHandler != null) {
            this.dataHandler.handle(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleEnd(MultiMap trailers) {
        this.ended = true;
        ((Http2ServerConnection)this.conn).reportBytesRead(this.bytesRead);
        if (this.postRequestDecoder != null) {
            try {
                this.postRequestDecoder.offer(LastHttpContent.EMPTY_LAST_CONTENT);
                while (this.postRequestDecoder.hasNext()) {
                    InterfaceHttpData data = this.postRequestDecoder.next();
                    if (!(data instanceof Attribute)) continue;
                    Attribute attr = (Attribute)data;
                    try {
                        this.formAttributes().add(attr.getName(), attr.getValue());
                    }
                    catch (Exception e) {
                        this.handleException(e);
                    }
                }
            }
            catch (HttpPostRequestDecoder.EndOfDataDecoderException data) {
            }
            catch (Exception e) {
                this.handleException(e);
            }
            finally {
                this.postRequestDecoder.destroy();
            }
        }
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    @Override
    void handleReset(long errorCode) {
        this.ended = true;
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(new StreamResetException(errorCode));
        }
        this.response.callReset(errorCode);
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    private void checkEnded() {
        if (this.ended) {
            throw new IllegalStateException("Request has already been read");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.exceptionHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest handler(Handler<Buffer> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.dataHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest pause() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.doPause();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest resume() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.doResume();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest endHandler(Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.endHandler = handler;
        }
        return this;
    }

    @Override
    public HttpVersion version() {
        return HttpVersion.HTTP_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpMethod method() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            if (this.method == null) {
                String sMethod = this.headers.method().toString();
                this.method = HttpUtils.toVertxMethod(sMethod);
            }
            return this.method;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String rawMethod() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            if (this.rawMethod == null) {
                this.rawMethod = this.headers.method().toString();
            }
            return this.rawMethod;
        }
    }

    @Override
    public boolean isSSL() {
        return ((Http2ServerConnection)this.conn).isSsl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String uri() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            CharSequence path2;
            if (this.uri == null && (path2 = this.headers.path()) != null) {
                this.uri = path2.toString();
            }
            return this.uri;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String path() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            CharSequence path2;
            if (this.path == null && (path2 = this.headers.path()) != null) {
                this.path = HttpUtils.parsePath(path2.toString());
            }
            return this.path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String query() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            CharSequence path2;
            if (this.query == null && (path2 = this.headers.path()) != null) {
                this.query = HttpUtils.parseQuery(path2.toString());
            }
            return this.query;
        }
    }

    @Override
    public String scheme() {
        CharSequence scheme = this.headers.scheme();
        return scheme != null ? scheme.toString() : null;
    }

    @Override
    public String host() {
        CharSequence authority = this.headers.authority();
        return authority != null ? authority.toString() : null;
    }

    @Override
    public Http2ServerResponseImpl response() {
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap headers() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            if (this.headersMap == null) {
                this.headersMap = new Http2HeadersAdaptor(this.headers);
            }
            return this.headersMap;
        }
    }

    @Override
    public String getHeader(String headerName) {
        return this.headers().get(headerName);
    }

    @Override
    public String getHeader(CharSequence headerName) {
        return this.headers().get(headerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap params() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            if (this.params == null) {
                this.params = HttpUtils.params(this.uri());
            }
            return this.params;
        }
    }

    @Override
    public String getParam(String paramName) {
        return this.params().get(paramName);
    }

    @Override
    public SocketAddress remoteAddress() {
        return ((Http2ServerConnection)this.conn).remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return ((Http2ServerConnection)this.conn).localAddress();
    }

    @Override
    public SSLSession sslSession() {
        return ((Http2ServerConnection)this.conn).sslSession();
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return ((Http2ServerConnection)this.conn).peerCertificateChain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String absoluteURI() {
        if (this.method() == HttpMethod.CONNECT) {
            return null;
        }
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            if (this.absoluteURI == null) {
                try {
                    this.absoluteURI = HttpUtils.absoluteURI(this.serverOrigin, this);
                }
                catch (URISyntaxException e) {
                    log.error((Object)"Failed to create abs uri", e);
                }
            }
            return this.absoluteURI;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket netSocket() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            if (this.netSocket == null) {
                this.response.toNetSocket();
                this.netSocket = ((Http2ServerConnection)this.conn).toNetSocket(this);
            }
            return this.netSocket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest setExpectMultipart(boolean expect) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            if (expect) {
                CharSequence contentType;
                if (this.postRequestDecoder == null && (contentType = (CharSequence)this.headers.get(HttpHeaderNames.CONTENT_TYPE)) != null) {
                    znaishaded.io.netty.handler.codec.http.HttpMethod method = znaishaded.io.netty.handler.codec.http.HttpMethod.valueOf(this.headers.method().toString());
                    String lowerCaseContentType = contentType.toString().toLowerCase();
                    boolean isURLEncoded = lowerCaseContentType.startsWith(HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.toString());
                    if ((lowerCaseContentType.startsWith(HttpHeaderValues.MULTIPART_FORM_DATA.toString()) || isURLEncoded) && (method == znaishaded.io.netty.handler.codec.http.HttpMethod.POST || method == znaishaded.io.netty.handler.codec.http.HttpMethod.PUT || method == znaishaded.io.netty.handler.codec.http.HttpMethod.PATCH || method == znaishaded.io.netty.handler.codec.http.HttpMethod.DELETE)) {
                        DefaultHttpRequest req = new DefaultHttpRequest(znaishaded.io.netty.handler.codec.http.HttpVersion.HTTP_1_1, method, this.headers.path().toString());
                        req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
                        this.postRequestDecoder = new HttpPostRequestDecoder(new NettyFileUploadDataFactory(this.vertx, this, () -> this.uploadHandler), req);
                    }
                }
            } else {
                this.postRequestDecoder = null;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExpectMultipart() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            return this.postRequestDecoder != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest uploadHandler(@Nullable Handler<HttpServerFileUpload> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.uploadHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap formAttributes() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            if (this.attributes == null) {
                this.attributes = new CaseInsensitiveHeaders();
            }
            return this.attributes;
        }
    }

    @Override
    public String getFormAttribute(String attributeName) {
        return this.formAttributes().get(attributeName);
    }

    @Override
    public ServerWebSocket upgrade() {
        throw new UnsupportedOperationException("HTTP/2 request cannot be upgraded to a websocket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnded() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            return this.ended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest customFrameHandler(Handler<HttpFrame> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.customFrameHandler = handler;
            return this;
        }
    }

    @Override
    public HttpConnection connection() {
        return this.conn;
    }
}

