/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Closeable;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.logging.Logger;

class CloseHooks {
    private final Logger log;
    private boolean closeHooksRun;
    private Set<Closeable> closeHooks;

    CloseHooks(Logger log) {
        this.log = log;
    }

    synchronized void add(Closeable hook) {
        if (this.closeHooks == null) {
            this.closeHooks = new HashSet<Closeable>();
        }
        this.closeHooks.add(hook);
    }

    synchronized void remove(Closeable hook) {
        if (this.closeHooks != null) {
            this.closeHooks.remove(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(Handler<AsyncResult<Void>> completionHandler) {
        HashSet<Closeable> copy = null;
        CloseHooks closeHooks = this;
        synchronized (closeHooks) {
            if (this.closeHooksRun) {
                throw new IllegalStateException("Close hooks already run");
            }
            this.closeHooksRun = true;
            if (this.closeHooks != null && !this.closeHooks.isEmpty()) {
                copy = new HashSet<Closeable>(this.closeHooks);
            }
        }
        if (copy != null && !copy.isEmpty()) {
            int num = copy.size();
            if (num != 0) {
                AtomicInteger count = new AtomicInteger();
                AtomicBoolean failed = new AtomicBoolean();
                for (Closeable hook : copy) {
                    Future<Void> a = Future.future();
                    a.setHandler(ar -> {
                        if (ar.failed()) {
                            if (failed.compareAndSet(false, true)) {
                                completionHandler.handle(Future.failedFuture(ar.cause()));
                            }
                        } else if (count.incrementAndGet() == num) {
                            completionHandler.handle(Future.succeededFuture());
                        }
                    });
                    try {
                        hook.close(a);
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)"Failed to run close hooks", t);
                        a.tryFail(t);
                    }
                }
            } else {
                completionHandler.handle(Future.succeededFuture());
            }
        } else {
            completionHandler.handle(Future.succeededFuture());
        }
    }
}

