/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.net;

import znaishaded.io.vertx.codegen.annotations.DataObject;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.http.ClientAuth;
import znaishaded.io.vertx.core.json.JsonObject;
import znaishaded.io.vertx.core.net.JdkSSLEngineOptions;
import znaishaded.io.vertx.core.net.JksOptions;
import znaishaded.io.vertx.core.net.KeyCertOptions;
import znaishaded.io.vertx.core.net.NetServerOptionsConverter;
import znaishaded.io.vertx.core.net.OpenSSLEngineOptions;
import znaishaded.io.vertx.core.net.PemKeyCertOptions;
import znaishaded.io.vertx.core.net.PemTrustOptions;
import znaishaded.io.vertx.core.net.PfxOptions;
import znaishaded.io.vertx.core.net.SSLEngineOptions;
import znaishaded.io.vertx.core.net.TCPSSLOptions;
import znaishaded.io.vertx.core.net.TrustOptions;

@DataObject(generateConverter=true, publicConverter=false)
public class NetServerOptions
extends TCPSSLOptions {
    public static final int DEFAULT_PORT = 0;
    public static final String DEFAULT_HOST = "0.0.0.0";
    public static final int DEFAULT_ACCEPT_BACKLOG = -1;
    public static final ClientAuth DEFAULT_CLIENT_AUTH = ClientAuth.NONE;
    public static final boolean DEFAULT_SNI = false;
    private int port;
    private String host;
    private int acceptBacklog;
    private ClientAuth clientAuth;
    private boolean sni;

    public NetServerOptions() {
        this.init();
    }

    public NetServerOptions(NetServerOptions other) {
        super(other);
        this.port = other.getPort();
        this.host = other.getHost();
        this.acceptBacklog = other.getAcceptBacklog();
        this.clientAuth = other.getClientAuth();
        this.sni = other.isSni();
    }

    public NetServerOptions(JsonObject json) {
        super(json);
        this.init();
        NetServerOptionsConverter.fromJson(json, this);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        NetServerOptionsConverter.toJson(this, json);
        return json;
    }

    @Override
    public NetServerOptions setSendBufferSize(int sendBufferSize) {
        super.setSendBufferSize(sendBufferSize);
        return this;
    }

    @Override
    public NetServerOptions setReceiveBufferSize(int receiveBufferSize) {
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    @Override
    public NetServerOptions setReuseAddress(boolean reuseAddress) {
        super.setReuseAddress(reuseAddress);
        return this;
    }

    @Override
    public NetServerOptions setReusePort(boolean reusePort) {
        super.setReusePort(reusePort);
        return this;
    }

    @Override
    public NetServerOptions setTrafficClass(int trafficClass) {
        super.setTrafficClass(trafficClass);
        return this;
    }

    @Override
    public NetServerOptions setTcpNoDelay(boolean tcpNoDelay) {
        super.setTcpNoDelay(tcpNoDelay);
        return this;
    }

    @Override
    public NetServerOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        super.setTcpKeepAlive(tcpKeepAlive);
        return this;
    }

    @Override
    public NetServerOptions setSoLinger(int soLinger) {
        super.setSoLinger(soLinger);
        return this;
    }

    @Override
    public NetServerOptions setUsePooledBuffers(boolean usePooledBuffers) {
        super.setUsePooledBuffers(usePooledBuffers);
        return this;
    }

    @Override
    public NetServerOptions setIdleTimeout(int idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        return this;
    }

    @Override
    public NetServerOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    @Override
    public NetServerOptions setUseAlpn(boolean useAlpn) {
        super.setUseAlpn(useAlpn);
        return this;
    }

    @Override
    public NetServerOptions setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        super.setSslEngineOptions(sslEngineOptions);
        return this;
    }

    @Override
    public NetServerOptions setJdkSslEngineOptions(JdkSSLEngineOptions sslEngineOptions) {
        return (NetServerOptions)super.setSslEngineOptions(sslEngineOptions);
    }

    @Override
    public NetServerOptions setOpenSslEngineOptions(OpenSSLEngineOptions sslEngineOptions) {
        return (NetServerOptions)super.setSslEngineOptions(sslEngineOptions);
    }

    @Override
    public NetServerOptions setKeyCertOptions(KeyCertOptions options) {
        super.setKeyCertOptions(options);
        return this;
    }

    @Override
    public NetServerOptions setKeyStoreOptions(JksOptions options) {
        super.setKeyStoreOptions(options);
        return this;
    }

    @Override
    public NetServerOptions setPfxKeyCertOptions(PfxOptions options) {
        return (NetServerOptions)super.setPfxKeyCertOptions(options);
    }

    @Override
    public NetServerOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        return (NetServerOptions)super.setPemKeyCertOptions(options);
    }

    @Override
    public NetServerOptions setTrustOptions(TrustOptions options) {
        super.setTrustOptions(options);
        return this;
    }

    @Override
    public NetServerOptions setTrustStoreOptions(JksOptions options) {
        super.setTrustStoreOptions(options);
        return this;
    }

    @Override
    public NetServerOptions setPfxTrustOptions(PfxOptions options) {
        return (NetServerOptions)super.setPfxTrustOptions(options);
    }

    @Override
    public NetServerOptions setPemTrustOptions(PemTrustOptions options) {
        return (NetServerOptions)super.setPemTrustOptions(options);
    }

    @Override
    public NetServerOptions addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    @Override
    public NetServerOptions addEnabledSecureTransportProtocol(String protocol) {
        super.addEnabledSecureTransportProtocol(protocol);
        return this;
    }

    @Override
    public NetServerOptions removeEnabledSecureTransportProtocol(String protocol) {
        return (NetServerOptions)super.removeEnabledSecureTransportProtocol(protocol);
    }

    @Override
    public NetServerOptions setTcpFastOpen(boolean tcpFastOpen) {
        return (NetServerOptions)super.setTcpFastOpen(tcpFastOpen);
    }

    @Override
    public NetServerOptions setTcpCork(boolean tcpCork) {
        return (NetServerOptions)super.setTcpCork(tcpCork);
    }

    @Override
    public NetServerOptions setTcpQuickAck(boolean tcpQuickAck) {
        return (NetServerOptions)super.setTcpQuickAck(tcpQuickAck);
    }

    @Override
    public NetServerOptions addCrlPath(String crlPath) throws NullPointerException {
        return (NetServerOptions)super.addCrlPath(crlPath);
    }

    @Override
    public NetServerOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        return (NetServerOptions)super.addCrlValue(crlValue);
    }

    public int getAcceptBacklog() {
        return this.acceptBacklog;
    }

    public NetServerOptions setAcceptBacklog(int acceptBacklog) {
        this.acceptBacklog = acceptBacklog;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public NetServerOptions setPort(int port2) {
        if (port2 < 0 || port2 > 65535) {
            throw new IllegalArgumentException("port p must be in range 0 <= p <= 65535");
        }
        this.port = port2;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public NetServerOptions setHost(String host) {
        this.host = host;
        return this;
    }

    @Deprecated
    public boolean isClientAuthRequired() {
        return this.clientAuth == ClientAuth.REQUIRED;
    }

    @Deprecated
    public NetServerOptions setClientAuthRequired(boolean clientAuthRequired) {
        this.clientAuth = clientAuthRequired ? ClientAuth.REQUIRED : ClientAuth.NONE;
        return this;
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public NetServerOptions setClientAuth(ClientAuth clientAuth) {
        this.clientAuth = clientAuth;
        return this;
    }

    @Override
    public NetServerOptions setLogActivity(boolean logEnabled) {
        return (NetServerOptions)super.setLogActivity(logEnabled);
    }

    public boolean isSni() {
        return this.sni;
    }

    public NetServerOptions setSni(boolean sni) {
        this.sni = sni;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetServerOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetServerOptions that = (NetServerOptions)o;
        if (this.acceptBacklog != that.acceptBacklog) {
            return false;
        }
        if (this.clientAuth != that.clientAuth) {
            return false;
        }
        if (this.port != that.port) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        return this.sni == that.sni;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.port;
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + this.acceptBacklog;
        result = 31 * result + this.clientAuth.hashCode();
        result = 31 * result + (this.sni ? 1 : 0);
        return result;
    }

    private void init() {
        this.port = 0;
        this.host = DEFAULT_HOST;
        this.acceptBacklog = -1;
        this.clientAuth = DEFAULT_CLIENT_AUTH;
        this.sni = false;
    }
}

